# General, Copyright (c) 2001-2003 by David R. Bickel.
# Created by David R. Bickel on 10/1/01.
# 8/7/02. 'clip' changed to 'crop' throughout.
# 8/2/02. data.frame.as.matrices and matrices.as.data.frame added.

# 4/25/02. winsorize option added to clip.vector.
# 4/24/02. win.vector added.
# 4/8/02. trim.vector error fixed.
# 4/6/02. balance.sample and take added.
# 4/1/02. clip.vector added.
# 2/28/02 trim.vector added.

print(date())

using.r <- (!is.null(version$language) && version$language == 'R')

print.frame<-function(s,index1=1,index2=length(s[[1]]),max.length=1) {
	for(i in 1:length(s))
	{
		print(names(s)[i]);
		for(j in index1:index2)
		{	
			to.print<-s[[i]][[j]];
#print(c(i,j));
#print(length(to.print));
			if(length(to.print)<=max.length) print(to.print)
				else cat('Length of ',length(to.print),'>',max.length,'\n');
		}
	}
}

field.vector<-function(f,fieldname=names(f)[1])
{
  as.vector(t(f[fieldname]))
}

field.character <- function(f,fieldname=names(f)[1])
{
  as.character(field.vector(f, fieldname = fieldname))
}

sort.data.frame<-function(f,field.to.sort=names(f)[1],...) # perhaps better to do something like f[order(f[, field.to.sort]), ]
{
#      permvector<-order(fieldvector<-as.vector(t(f[field.to.sort])),...);
      permvector<-order(fieldvector<-field.vector(f,field.to.sort),...);
      f[permvector,]
}

matrix.from.vectors<-function(vectors)
{
print('begin matrix.from.vectors');
  vec<-vectors[[1]];
cat('# vectors: ',length(vectors),'\n');
  if(length(vectors)>1)
    for(i in 2:length(vectors))
      vec<-c(vec,vectors[[i]]);
print('finishing matrix.from.vectors');
  matrix(vec,ncol=length(vectors))
}

vectors.from.matrix<-function(m)
{
print('begin vectors.from.matrix');
  vecs<-list();
  for(i in 1:ncol(m))
    vecs[[i]]<-m[,i];
  vecs
}

t.vectors<-function(vectors)
{
print('begin t.vectors');
  vectors.from.matrix(t(matrix.from.vectors(vectors)))
}

saving.results <- function(file.base)
{
  (! (is.null(file.base) || !is.character(file.base) || file.base==''))
}

save.spreadsheet <- function(x, file="untitled.xls",sep='\t',col.names=NA,...)
{if(is.null(x) || !saving.results(file)) stop(paste(file,'cannot be saved.')) else write.table(x, file = file, sep = sep, col.names = col.names,...)}
#save.spreadsheet <- function(x, file="untitled.xls", sep='\t', col.names = FALSE, row.names = TRUE, ...)
#{if(is.null(x) || !saving.results(file)) stop(paste(file,'cannot be saved.')) else write.table(x, file = file, sep = #sep, col.names = col.names, row.names = row.names, ...)}

object.name.file <- function(file.base){paste(file.base, sep = 'N.', 'txt')}
object.file <- function(file.base, extension){paste(file.base, sep = '.', extension)}
default.extension <- function(ascii){if(ascii) 'txt' else 'RData'}

save.object <- function(object.name, object = NULL, file.base = object.name, ascii = FALSE, extension = default.extension(ascii), ...)
{
  if(is.null(object))
  {
    comma.or.not <- if(length(list(...)) > 0) ", " else ""
    cmd <- paste("save.object(object = ", object.name, ", file.base = '", file.base, "', object.name = '", object.name, "', ascii = ", ascii, ", extension = '", extension, "'", comma.or.not, ..., ")", sep = "")
    eval(parse(text = cmd))    
  }
  else
  {
    stopifnot(saving.results(file.base))
    dput(object.name, file = object.name.file(file.base))
    assign(object.name, object)
    cmd <- paste('save(', object.name,', file = object.file(file.base = file.base, extension = extension), ascii = ascii, ...)', sep = '')
    eval(parse(text = cmd))
  }
}

load.object <- function(file.base, ascii = FALSE, extension = default.extension(ascii), envir = .GlobalEnv)
{
  stopifnot(saving.results(file.base))
  ls0 <- ls(envir = envir)
  load(object.file(file.base = file.base, extension = extension), envir = envir)
  object.name <- dget(object.name.file(file.base))
  if(any(object.name == ls0)) warning(paste(object.name, 'was replaced'))
  object.name
}

# save.plus <- function(..., file, envir = .GlobalEnv) {save(..., file = file, envir = envir, ...)}

load.plus <- function(file, envir = .GlobalEnv)
# This is ideal when loading a file created by save.image().
# This is similar to load.object, but it does not require a name file. The drawback is that it will not return the name if it was already in use.
{
  ls0 <- ls(envir = envir)
  load(file, envir = envir)
  ls1 <- ls(envir = envir)
  new.names <- ls1[sapply(ls1, function(name){!any(ls0 == name)})]
  if(length(new.names) == 0) warning('The name of the loaded data was replaced.')
  new.names
}

cor.vectors<-function(row.vectors,col.vectors=row.vectors)
{  
  cor.vector<-function(row.vector)
  {
    sapply(col.vectors,function(vec){cor(vec,row.vector)})
  }
  lapply(row.vectors,cor.vector)
}

subtract<-function(x,y){x-y}

lists.apply<-function(list1,list2,two.arg.fcn=subtract)
{
  new.list<-list();
  if(length(list1)!=length(list2))
    cat("lists.apply error: unequal lengths; ",length(list1),"!=",length(list2),"\n")
  else
    for(i in 1:length(list1))
      new.list[[i]]<-two.arg.fcn(list1[[i]],list2[[i]])
  new.list
}

two.factor.anova<-function(random.matrix)
{
  cat('ROW MEANS: ',row.means<-apply(random.matrix,1,mean),'\n');
  cat('COL MEANS: ',col.means<-apply(random.matrix,2,mean),'\n');
  row.sums<-apply(random.matrix,1,sum);
  col.sums<-apply(random.matrix,2,sum);
  grand.sum<-sum(random.matrix);
  cat('GRAND SUM: ',grand.sum,'\n');
  I<-nrow(random.matrix);
  J<-ncol(random.matrix);
  intercept.term<-grand.sum^2/(I*J);
  cat('Intercept term: ',intercept.term,'\n');
  sst<-sum(random.matrix^2)-intercept.term;
  ssa<-sum(row.sums^2)/J-intercept.term;
  ssb<-sum(col.sums^2)/I-intercept.term;
  sse<-sst-ssa-ssb;
  cat('SS: ',c(sst,ssa,ssb,sse),'\n');
  dof.row<-I-1;
  dof.col<-J-1;
  dof.err<-(I-1)*(J-1);
  msa<-ssa/dof.row;
  msb<-ssb/dof.col;
  mse<-sse/dof.err;
  f.row<-msa/mse;
  f.col<-msb/mse;
  p.row<-pf(f.row,dof.row,dof.err,lower.tail=FALSE);
  p.col<-pf(f.col,dof.col,dof.err,lower.tail=FALSE);
  data.frame(cbind(dof=c(dof.row,dof.col,dof.err),ss=c(ssa,ssb,sse),ms=c(msa,msb,mse),f.stat=c(f.row,f.col,NA),p.value=c(p.row,p.col,NA)))
}

take.components<-function(v,will.take.component=function(c){is.finite(c)}) # legacy
{
  v2<-vector();
  j<-1;
  for(i in 1:length(v))
  {
    c2<-v[i];
    if(will.take.component(c2))
    {
      v2[j]<-c2;
      j<-j+1;
    }
  }
  v2
}

trim.vector <- function(x, trim=0)
{
  v <- sort(x)
  trim.num <- floor(length(v)*trim)
  if(trim > .5) stop('trimming portion should be less than or equal to 0.5')
  min.i <- 1+trim.num
  max.i <- length(v)-trim.num
  if(max.i < min.i)
  {
    if(max.i == min.i - 1)
      return(mean(c(v[max.i],v[min.i])))
    else
      stop('trim.vector error')
  }
  else
    v[min.i:max.i]
}
#{bounds <- quantile(v, probs=c(trim,1-trim)); v[v>=bounds[1] & v<=bounds[2]]} # mean(trim.vector(v,trim=tr))==mean(v,trim=tr)

win.vector <- function(x, win=0)
{
  v <- sort(x)
  win.num <- floor(length(v)*win)
  if(win > .5) stop('Winsor portion should be less than or equal to 0.5')
  min.i <- 1+win.num
  max.i <- length(v)-win.num
  if(max.i < min.i)
  {
    if(max.i == min.i - 1)
      return(rep(mean(c(v[max.i],v[min.i])), length(x)))
    else
      stop('win.vector error')
  }
  else
    c(rep(v[min.i], win.num), v[min.i:max.i], rep(v[max.i], win.num))
}

crop.vector <- function(v, crop=0, new.length = ceiling((1-crop)*length(v)), winsorize = FALSE)
{
  n <- new.length
#print(n)
  x <- sort(v)
  min.r <- x[length(x)]-x[1]+1
#print(min.r)
  for(i in 1:(length(x)-n+1))
  {
#print(i)
#print(x[i+n-1])
#print(x[i])
#print(x[i+n-1]-x[i]);
    if(x[i+n-1]-x[i]<=min.r)
    {
      if(x[i+n-1]-x[i]==min.r)
        warning('Clipped vector is not unique.')
      min.r <- x[i+n-1]-x[i]
      min.r.i <- i
    }
  }
  min.r.j <- min.r.i+n-1
  cropped <- x[min.r.i:min.r.j]
  if(winsorize)
    return (c(rep(x[min.r.i], min.r.i - 1), cropped, rep(x[min.r.j], length(x) - min.r.j)))
  else
    return (cropped)
}

take <- function(x, min.index, max.index)
{
  if(max.index < min.index)
    NULL
  else
    x[min.index:max.index]
}

combine.factors <- function(factor1, factor2) # added 7/25/02
{
  if(!identical(levels(factor1), levels(factor2))) {print('Inconsistent levels.'); browser()}
  factor(c(as.vector(factor1), as.vector(factor2)), levels = levels(factor1))
}

balance.sample <- function(x, y, replace=FALSE)
{
  if(replace)
    stop('replace=TRUE not yet implemented for balance.sample')
  else
  {
    n.from.x.for.x0 <- length(x)^2/(length(x)+length(y))
    prob.extra.from.x.for.x <- n.from.x.for.x0 - floor(n.from.x.for.x0)
    n.from.x.for.x <- floor(n.from.x.for.x0)
    if(runif(1) < prob.extra.from.x.for.x)
      n.from.x.for.x <- n.from.x.for.x + 1
    n.from.y.for.x <- length(x) - n.from.x.for.x
    perm.x <- sample(x,replace=FALSE)
    perm.y <- sample(y,replace=FALSE)
    x2 <- combine.factors(take(perm.x,1,n.from.x.for.x),take(perm.y,1,n.from.y.for.x))
    y2 <- combine.factors(take(perm.x,(n.from.x.for.x+1),length(x)),take(perm.y,(n.from.y.for.x+1),length(y)))
    if(length(x)+length(y)!=length(x2)+length(y2))
    {
      cat(n.from.x.for.x0,' ',prob.extra.from.x.for.x,' ',n.from.x.for.x,'\n')
      cat('x',x,' y',y,'\n')
      cat('x2',x2,' y2',y2,'\n')
      stop('length error in balance.sample(...,replace=FALSE)')
    }
    list(sample(x2,replace=FALSE),sample(y2,replace=FALSE))
  }
}

matrices.as.data.frame <- function(matrices)
# returns transposition of the matrices as a data frame, the last column of which is a factor corresponding to the matrices
# inverse of data.frame.as.matrices (except possibly for names)
{
  nvar <- nrow(matrices[[1]])
  if(!identical(TRUE, all(sapply(matrices, function(mat) {nrow(mat)}) == nvar)))
    stop('Each matrix must have the same number of rows.')

#  datf <- as.data.frame(matrix(sapply(1:nvar, function(i) {sapply(matrices, function(mat) {mat[i, ]})}), ncol = nvar))
  datf <- as.data.frame(t(do.call('cbind', matrices)))
  
  if(!identical(TRUE, all(sapply(matrices, rownames) == rownames(matrices[[1]]))) && !all(is.na(sapply(matrices, rownames))))
  {
    warning('Inconsistent matrix row names. Names of the data frame will not correspond to the names of each matrix.')
    names(datf) <- (1:ncol(datf))
  }
  matrix.names <- if(is.null(names(matrices))) (1:length(matrices)) else names(matrices)
  cbind(datf, matrix.factor = as.factor(do.call('c', lapply(1:length(matrices), function(i) {rep(matrix.names[i], ncol(matrices[[i]]))}))))
}

data.frame.as.matrices <- function(dataframe)
# returns a tranposed matrix for each level of the last column of dataframe
# inverse of matrices.as.data.frame (except possibly for names)
{
  nvar <- ncol(dataframe) - 1
  fac <- dataframe[, nvar + 1]
  stopifnot(is.factor(fac))
  levs <- levels(fac)
  mats <- lapply(levs, function(lev) {t(dataframe[fac == lev, 1:nvar])})
  names(mats) <- levs
  mats
}

data.frames.as.array <- function(dataframes)
# Returns a 3-dimensional array.
{
  stopifnot(is.list(dataframes))
  mats <- lapply(dataframes, as.matrix)
  dims <- sapply(mats, dim)
  dim0 <- dims[, 1]
  stopifnot(all(dims[1, ] == dim0[1]))
  stopifnot(all(dims[2, ] == dim0[2]))
  vec <- do.call('c', mats)
#  vec <- sapply(mats, function(s){s})
  stopifnot(length(vec) == dim0[1] * dim0[2] * length(mats))
  arr <- array(vec, dim = c(dim0, length(mats)))
  rnames <- row.names(dataframes[[1]])
  stopifnot(is.null(rnames) || all(sapply(dataframes, function(datf){identical(TRUE, all.equal(rnames, row.names(datf)))})))
  cnames <- variable.names(dataframes[[1]])
  stopifnot(is.null(cnames) || all(sapply(dataframes, function(datf){identical(TRUE, all.equal(cnames, variable.names(datf)))})))
  dimnames(arr) <- list(rnames, cnames, names(dataframes))
  arr
}

all.eq <- function(target, current, exact = FALSE, ...)
{
  if(exact)
    all(target == current)
  else
    identical(TRUE, all.equal(target, current, ...))
}

product <- function(...)
{
  lis <- as.list(...)
  if(!is.list(lis)) {print('Could not convert arguments to list'); browser()}
  stopifnot(length(lis) > 0)
  if(length(lis) == 1)
    lis[[1]]
  else 
  {
    if(length(lis) == 2)
      lis[[1]] * lis[[2]]
    else
      product(do.call('c', c(lis[[1]] * lis[[2]], lis[-1:-2])))
  }
}

bind.arrays.3d <- function(...)
{
  arrays <- list(...)
  arr.dim <- c(dim(arrays[[1]])[1:2], sum(sapply(arrays, function(arr){dim(arr)[3]})))
  stopifnot(length(arr.dim) == 3)
  if(!all(sapply(arrays, function(arr){identical(TRUE, all.equal(arr.dim[1:2], dim(arr)[1:2]))})))
  { print('Inconsistent arrays'); browser()}
  get.names <- function(arr, dimen){dimnames(arr)[[dimen]]}
  names1 <- get.names(arrays[[1]], 1)
  if(!all(sapply(arrays, function(arr){all.eq(names1, get.names(arr, 1))})))
  { print('Inconsistent dimnames in first dimension'); browser()}
  names2 <- get.names(arrays[[1]], 2)
  if(!all(sapply(arrays, function(arr){all.eq(names2, get.names(arr, 2))})))
  { print('Inconsistent names in second dimension'); browser()}
  names3.list <- lapply(arrays, function(arr){get.names(arr, 3)})
  names3 <- if(any(sapply(names3.list, is.null))) NULL else as.vector(do.call('c', names3.list))
  if(!is.null(names3) && length(names3) != arr.dim[3]) {print('Problem with dimnames in third dimension'); browser()}
  prearray <- do.call('c', arrays)
  stopifnot(length(prearray) == product(arr.dim))
  array(data = prearray, dim = arr.dim, dimnames = list(names1, names2, names3))
}

simplify.matrix <- function(mat)
{
  if(is.matrix(mat) && ncol(mat) == 1)
    as.vector(mat)
  else
    mat
}

fields <- function(objects, field.name, simplify = TRUE)
# Replaced frame.fields.as.matrix on 3/29/03.
{
  stopifnot(is.list(objects) && is.character(field.name))
  field <- function(object)
  {
    if(is.data.frame(object)) object[, field.name]
    else
    {
      if(is.list(object)) object[[field.name]] else stop('Invalid objects')
    }
  }
  mat <- sapply(objects, field)
  if(simplify) simplify.matrix(mat) else mat
}


standardize <- function(x, mean = 0, sd = 1) {x2 <- x * sd / sd(x); x2 - mean(x2) + mean}

seed.random <- function(seed, kind = 'Knuth-TAOCP-2002') {print(paste(kind, 'with seed', seed,'as of',date())); set.seed(seed, kind)}

integer.rank <- function(vec) {mat <- cbind(1:length(vec), order(vec)); sapply(mat[, 1], function(y){mat[(y == mat[, 2]), 1]})}

cool.cat <- function(..., sep = '') {cat(..., '\n', sep = sep)}

random.matrix <- function(ncases, means, standard.deviations = rep(1, length(means))) # data.matrix before 3/24/03
{
  if(is.null(means) || !is.vector(means) || length(means) == 0) {print('invalid means'); browser()}
  mat <- matrix(sapply(1:length(means), function(i) {rnorm(ncases, mean = means[i], sd = standard.deviations[i])}), ncol = ncases, byrow = TRUE)
  stopifnot(nrow(mat) == length(means))
  mat
}

random.null.default <- function(n){rnorm(n, mean = 0, sd = 1)}
random.alt.default <- function(n){(if(rbern(n = 1, prob = .5)) 1 else -1) * rnorm(n, mean = 2, sd = 1)}

data.from.mixture <- function(probs.alt, sample.size, random.null = random.null.default, random.alt = random.alt.default)
{
  t(sapply(probs.alt, function(prob.alt){if(rbern(n = 1, prob = prob.alt)) random.alt(sample.size) else random.null(sample.size)}))
}

classification.error <- function(true.classes, putative.classes)
{
  stopifnot(length(putative.classes) == length(true.classes))
  sum(true.classes != putative.classes) / length(true.classes)
}

rbern <- function(n, prob) {rbinom(n = n, 1, prob = prob)}
# rlogical <- function(n, prob) {rbern(n = n, prob = prob) == 1} # not needed since 0 and 1 are treated as logicals

full.path <- function(relative.path, sep = '') {paste(getwd(), relative.path, sep = sep)}

file.or.full.path <- function(relative.path = NULL, file = NULL, sep = '')
{
  if(is.null(relative.path)) file else full.path(relative.path, sep = sep)
}

first.differences <- function(x) {x[-1] - x[-length(x)]}

standardize.names <- function(names)
{
  proper.names <- casefold(names)
  stopifnot(length(proper.names) == length(unique(proper.names)))
  proper.names
}

eval.arg <- function(..., print.cmd = FALSE)
{
  cmd <- paste(..., sep = '')
  if(print.cmd) cool.cat(cmd)
  parse(text = cmd)
}
