# DifferenceTests, Copyright (c) 2001-2003 by David R. Bickel.

# DifferenceTests divided into DiffTests, MultTests, and TestStats on 7/29/02.
# Created by David R. Bickel on 10/1/01.
# 7/12/02. multcomp changed to multtests throughout to avoid conflict with the multcomp package.
# 6/17/02. progess.file.base replace with file.base throughout.
# 6/14/02. paired.diff.tests modified to depend on gen.paired.diff.tests.
# 6/6/02. multcomp added and four old functions (gen.t.tests, location.tests, diff.tests, paired.diff.tests) now call it; tests of these functions for the single-comparison case are recorded in the R consoles R multcomp01 and R multcomp02.
# 5/13/02. default NULL added to y of t.test.plus.
# 5/10/02. paired.diff.tests added.
# 5/2/02. gen.t.tests has file option.
# 5/1/02. diff.tests modified. 
# 4/29/02. diff.scale.estimator added to diff.tests.
# 4/16/02. This error in diff.tests corrected: desum was fixed with location.estimator = mean.
# 4/13/02. desum added.
# 4/6/02. diff.tests added.
# 4/1/02. replace added to gen.t.test.
# 2/25/02. t.test.plus added.

source("Estimation.r")

gen.t.stat <- function(x, y, mu = 0, location.estimator = mean, scale.estimator = sd, return.scales = FALSE, var.equal = FALSE) {
  mx<-location.estimator(x);
  my<-location.estimator(y);
  if(!is.finite(mx)) {print(x); print(location.estimator); stop('mx is not finite')}
  if(!is.finite(my)) {print(y); print(location.estimator); stop('my is not finite')}
  gentstat <- if(!is.function(scale.estimator))
    mx-my-mu
  else
  {
    sx<-scale.estimator(x)
    sy<-scale.estimator(y)
# print(c(mx,my,sx,sy))
    if(mx-my-mu==0)
    {
      warning('gen.t.stat will return exactly 0')
      0
    }
    else
    {
      if(is.na(sx) || is.na(sy))
        warning('scales are not both numeric, so gen.t.stat does not return a number')
      else
      {
        if(sx == 0 && sy == 0)
          warning('scale of each sample is 0, so gen.t.stat does not return a number')
      }
      if(var.equal)
      {
        m <- length(x); n <- length(y)
        sig <- sqrt((sx^2 * (m - 1) + sy^2 * (n - 1)) / (m + n - 2))
        (mx-my-mu) / (sig * sqrt(1/m + 1/n))
      }
      else
        (mx-my-mu)/sqrt(sx^2/length(x)+sy^2/length(y))
    }
  }
  if(return.scales)
    list(gentstat = gentstat, x.scale = sx, y.scale = sy)
  else
    gentstat
}

gen.paired.t.stat <- function(diff.vector, location.estimator = mean, scale.estimator = sd)
{
  mu <- location.estimator(diff.vector)
  sig <- ifelse(is.function(scale.estimator), scale.estimator(diff.vector), 1) # is.function(scale.estimator) added 7/15/02
  ifelse(mu==0, 0, ifelse(sig==0, browser(), mu/(sig/sqrt(length(diff.vector)))))
    # 8/8/02 sig replaced with sig/sqrt(length(diff.vector))
}

p.value.stat <- function(p.from.distr)
{
  if(any(p.from.distr < 0 | p.from.distr > 1)) {print('Invalid p.from.distr.'); browser()}
  p.from.distr - 0.5
}

p.value.stat.to.p.value <- function(pstat, alternative = c('two.sided', 'less', 'greater'))
{
  alternative <- match.arg(alternative)
  p.from.distr <- pstat + 0.5  # inverse of p.value.stat
  p <- switch(alternative,
    'two.sided' = ifelse(p.from.distr <= 0.5, 2 * p.from.distr, 2 * (1 - p.from.distr)),
    'less' = p.from.distr,
    'greater' = 1 - p.from.distr,
    stop('Invalid alternative.')
  )
  if(any(p < 0 | p > 1)) {print('Invalid p-value.'); browser()}
  p
}

p.value.to.p.value.stat <- function(p, alternative = c('two.sided', 'less', 'greater'), test.stat.is.high = NULL)
{
  if(any(p < 0 | p > 1)) {print('Invalid p-value.'); browser()}
  alternative <- match.arg(alternative)
  if(alternative == 'two.sided') stopifnot(is.logical(test.stat.is.high))
  p.from.distr <-
    switch(alternative,
      'two.sided' = ifelse(test.stat.is.high, (1 - p / 2), p / 2),
      'less' = p,
      'greater' = 1 - p,
      stop('Invalid alternative.')
    )
  p.value.stat(p.from.distr)
}

gen.t.pstat <- function(x, y, mu = 0, location.estimator = mean, scale.estimator = sd, var.equal = FALSE, df = NULL)
{
  gen.t.stat.out <- gen.t.stat(x = x, y = y, mu = mu, location.estimator = location.estimator, scale.estimator = scale.estimator, var.equal = var.equal, return.scales = TRUE)
  sx <- gen.t.stat.out$x.scale; sy <- gen.t.stat.out$y.scale
  m <- length(x); n <- length(y)
  if(is.null(df))
  {
    df <- if(var.equal)
      m + n - 2
    else
      (sx^2/m + sy^2/n)^2 / ((sx^2/m)^2/(m - 1) + (sy^2/n)^2/(n - 1)) # degrees of freedom from Smith-Satterthwaite test
  }

  p.value.stat(pt(q = gen.t.stat.out$gentstat, df = df))
}

gen.paired.t.pstat <- function(diff.vector, location.estimator = mean, scale.estimator = sd, ...)
{p.value.stat(pt(q = gen.paired.t.stat(diff.vector = diff.vector, location.estimator = location.estimator, scale.estimator = scale.estimator, ...), df = length(diff.vector) - 1))}

p.value <- function(test.stat, cdf = pnorm, alternative = c('two.sided', 'less', 'greater'))
{
  alternative <- match.arg(alternative)
  if(cdf(1) < cdf(0)) stop('cdf must be a monotonic nondecreasing function')
  p <- sapply(test.stat, cdf)
  if(alternative == 'two.sided')
    sapply(p, function(p1){2*min(p1, 1-p1)})
  else
  {
    if (alternative == 'less')
      p
    else
      1-p
  }
}

change.teststat <- function(teststat0, teststats0, teststats, ...)
{approxfun(x = teststats0, y = teststats, ...)(teststat0)}