# Created by David Bickel on 17 August 2007.
# "Rank", signature(object = "numeric") changed and "sort", signature(x = "biasEstimate", decreasing = "ANY") added 8 April 2008, after Zahra Montazeri changed log to logb.
#  More changes 16 April 2008 and 24 April 2008.

# Also added after Zahra Montazeri changed log to logb:
saveo <- function(..., file)
{
	ext <- ".RData"
	if(missing(file))
	{
		warning("file argument must be explicit to be used")
		arglis <- list(...)
		cla <- sapply(arglis, class)
		boo <- cla == "character" & sapply(arglis, length) == 1
		if(FALSE) # any(boo))
		{
			whi <- which(boo)[1]
			lis <- try(c(arglis, list(file = arglis[[whi]]))) # [-whi]
			if(is(lis, "try-error"))
			{ message("bad lis"); browser()}
			dc <- try(do.call("saveo", lis))
			if(is(dc, "try-error"))
			{ message("bad dc"); browser()}
			return()
		}
		else
			file <- paste(Sys.Date(), " ", round(runif(1) * 1000), ext, sep = "")
	}
	sav <- function(...){save(...)}
	if(is.character(file) && length(file) > 1)
	{
		warning("using only the first element of file")
		saveo(file = file[1], ...)
	}
	else if(is.character(file) && length(file) == 1)
	{
		nc <- nchar(file)
		exten <- substr(file, start = nc - 5, stop = nc)
		if(exten != ".RData")
			file <- paste(file, ext, sep = "")
		message("saving ", file, " on ", date())
		sav(file = file, ...)
	}
	else
	{
		warning(paste(file, "is not a file name"))
		sav(file, ...)
	}
}
saveh <- function()
{
	file <- paste(Sys.Date(), "Rhistory", sep = ".")
	message("saving ", file, " in ", pwd(), " on ", date())
	savehistory(file = file)
}
savei <- function(file.base = "", ...)
{
	file <- paste(file.base, "RData", sep = ".")
	message("saving ", file, " in ", pwd(), " on ", date())
	save.image(file = file, ...)
}
loadi <- function(file.base = "", envir = .GlobalEnv, ...)
{
	file <- paste(file.base, "RData", sep = ".")
	message("loading ", file, " on ", date())
	load(file = file, envir = envir, ...)
}
savej <- function(...)
{
	saveh()
	savei(...)
	getwd()
}
pwd <- function(..., n = 20)
{
	path <- getwd(...)
	nc <- nchar(path)
	substr(path, max(1, nc - n + 1), nchar(path))
}
objectSize <- function(x, ...){printGeneric("objectSize"); browser()}
removeMethods("objectSize")
setMethod("objectSize", signature(x = "character"), function(x, i, verbose)
{
	if(missing(verbose))
	{
		verbose <- TRUE
		message("objectSize verbose = ", verbose)
	}
	nam <- x
	if(missing(i))
	{
		text <- paste("i = ", length(nam) - 9, ":", length(nam), sep = "")
		message(text)
		eval(parse(text = text))
	}
	sizes <- sapply(nam, function(nam)
	{
		eval(parse(text = paste("object.size(", nam, ")", sep = "")))
	}) / 1e6
	names(sizes) <- nam
	ord <- order(sizes)
	if(verbose)
	{
#		args.with.commas <- if(length(i) == 0)
#			character(0)
#		else
#			paste(nam[ord][i], ", ", sep = "")
		args.with.commas <- paste(nam[ord][i], collapse = ", ")
		message("For copy and paste: rm(", args.with.commas, ")")
		message(sum(sizes), " MBs of ", length(nam), " objects")
	}
	datf <- data.frame(object = nam, MB = sizes, index = 1:length(sizes))[ord, ]
	if(verbose)
		print(datf[i, ])
	invisible(datf)
})
global.environment <- environment()
setMethod("objectSize", signature(x = "missing"), function(x, name = global.environment, ...)
{
	nam <- objects(name = name)
	objectSize(x = nam, ...)
})
setClassUnion("index", c("logical", "numeric", "character"))
# end

plot.pch <- function()
{
	Pex <- 3 ## good for both .Device=="postscript" and "x11"
	ipch <- 0:35; np <- length(ipch); k <- floor(sqrt(np)); dd <- c(-1,1)/2
	rx <- dd + range(ix <- ipch %/% k)
	ry <- dd + range(iy <- 3 + (k-1)- ipch %% k)
	pch <- as.list(ipch)
	pch[26+ 1:10] <- as.list(c("*",".", "o","O","0","+","-","|","%","#"))
	plot(rx, ry, type="n", axes = FALSE, xlab = "", ylab = "",
			 main = paste("plot symbols :  points (...  pch = *, cex =", Pex,")"))
	abline(v = ix, h = iy, col = "lightgray", lty = "dotted")
	for(i in 1:np) {
		pc <- pch[[i]]
		points(ix[i], iy[i], pch = pc, col = "red", bg = "yellow", cex = Pex)
		## red symbols with a yellow interior (where available)
		text(ix[i] - .3, iy[i], pc, col = "brown", cex = 1.2)
	}
}

Stripchart <- function(x, ...)
{
	stripchart(x = x, ...)
}
removeMethods("Stripchart")
setMethod("Stripchart", signature(x = "matrix"), function(x, group.names, pch, ylab, circle, triangle, log, text.x, ...)
{
	if(missing(log))
	{
		log <- ""
		message("log = ", log)
	}
	if(missing(ylab)) ylab <- ""
	stopifnot(length(pch) == nrow(x))
	if(missing(circle) || length(circle) == 0)
	{
		circle <- numeric(0)
		message("matrix circle = ", circle)
	}
	if(is.character(circle) && is.character(pch))
	{
		stopifnot(circle %in% pch)
		circle <- which(circle == pch)
	}
	if(missing(triangle) || length(triangle) == 0)
	{
		triangle <- circle
		message("matrix triangle = ", triangle)
	}
	if(is.character(triangle) && is.character(pch))
	{
		stopifnot(triangle %in% pch)
		triangle <- which(triangle == pch)
	}
	shape.ok <- function(shape){length(shape) == 0 || shape %in% 1:length(pch)}
	stopifnot(shape.ok(circle) && shape.ok(triangle))
	y <- rep(ncol(x):1, nrow(x))
	xvec <- as.numeric(x)
	plot(x = xvec, y = y, type = "n", ylim = c(1, max(y) + 0.7), yaxt = "n", ylab = ylab, log = log, ...)
	stopifnot(length(group.names) == ncol(x))
	for(j in 1:ncol(x))
	{
		xv <- x[, j]
		yv <- rep(y[j], length(xv))
		points(x = xv, y = yv, pch = pch, ...)
		shape.points <- function(shape, pch)
		{
			if(length(shape) != 0)
				points(x = xv[shape], y = yv[shape], pch = pch, cex = 3)
		}
		shape.points(circle, pch = 1)
		shape.points(triangle, pch = 0)
#		points(x = xv[triangle], y = yv[triangle], pch = 0, cex = 3)
#		ti <- ceiling(length(xvec) / 2)
		midpoint <- function(vec)
		{
			ra <- range(vec, na.rm = TRUE)
			if(log != "")
				ra <- log(ra)
			mp <- mean(ra)
			if(log != "")
				mp <- exp(mp)
			mp
		}
		if(missing(text.x) || length(text.x) == 0)
		{
			text.x <- midpoint(vec = xvec)
			message(class(x), " text.x = ", text.x)
		}
		text(x = text.x, y = yv[1] + 0.3, labels = group.names[j])
	}
})
setMethod("Stripchart", signature(x = "list"), function(x, pch, ...)
{
	if(missing(pch) || length(pch) == 1 || any(length(pch) != sapply(x, length)))
	{
		message("Stripchart calling stripchart; press c to continue")
		browser()
		stripchart(x = x, pch = pch, ...)
	}
	else
	{
		mat <- try(sapply(x, as.numeric))
		if(is.matrix(mat))
		{
			message("Stripchart (list) calling Stripchart (matrix)")
			tr <- try(Stripchart(x = mat, pch = pch, ...))
			if(is(tr, "try-error"))
			{ message("Stripchart (matrix) failed"); browser()}
			tr
		}
		else
		{
			message("mat is not a matrix")
			browser()
		}
	}
})

scalar <- function(object, ...){message("scalar generic"); browser()}
removeMethods("scalar")
setMethod("scalar", signature(object = "scalar"), function(object)
{
	as(object, "scalar")
})
setMethod("scalar", signature(object = "ANY"), function(object)
{
	scalar(as.numeric(object))
})
setMethod("scalar", signature(object = "numeric"), function(object) # changed 16 April 2008
{
#  if(length(object) == 0)
#    stop("cannot convert vector of length 0 to scalar")
#  else 
  if(length(object) > 1)
  {
    warning("extra vector elements lost in coersion to scalar")
  	object <- object[1]
  }
  new("scalar", object)
})

Scalar <- function(object, ...){message("Scalar generic"); browser()}
removeMethods("Scalar")
setMethod("Scalar", signature(object = "ANY"), function(object) # changed 16 April 2008
{
#  if(length(object) == 0)
#    stop("cannot convert vector of length 0 to Scalar")
#  else if(length(object) > 1)
#    warning("extra vector elements lost in coersion to Scalar")
  Sca <- scalar(object)
  if(length(Sca) == 1 && !is.na(Sca) && Sca < 0)
    stop("cannot convert negative number to Scalar")
  new("Scalar", Sca)
})

pNumeric <- function(object, ...){message('pNumeric generic'); browser()}
removeMethods("pNumeric")
setMethod("pNumeric", signature(object = "numeric"), function(object)
{
  x <- new("pNumeric", as.numeric(object))
  names(x) <- names(x@.Data) <- names(object)
  x
})
Numeric <- function(object, ...){message('Numeric generic'); browser()}
removeMethods("Numeric")
setMethod("Numeric", signature(object = "numeric"), function(object)
{
  x <- new("Numeric", as.numeric(object))
  names(x) <- names(x@.Data) <- names(object)
  x
})
Matrix <- function(object, ...){message('Matrix generic'); browser()}
removeMethods("Matrix")
setMethod("Matrix", signature(object = "matrix"), function(object)
{
  new("Matrix", object)
})
setMethod("Matrix", signature(object = "numeric"), function(object)
{
  Numeric(object) # [sic]
})

Aggregate <- function(object, ...){printGeneric("Aggregate"); browser()}
removeMethods("Aggregate")
setMethod("Aggregate", signature(object = "data.frame"), function(object, by, FUN, ...)
{
	paste.dim <- function(x)
	{
		main.str <- paste(class(x), "of", nrow(x), "rows and", ncol(x), "columns")
		numeric.str <- paste("(", sum(sapply(x, is.numeric)), " of which are numeric)", sep = "")
		if(is(x, "data.frame"))
			paste(main.str, numeric.str)
		else
			main.str
	}
	dim0 <- paste.dim(object)
	get.fac.boo <- function(x)
	{
		boo <- sapply(x, is.factor)
		n.fac <- sum(boo)
		ok <- n.fac < ncol(x)
		if(!ok)
		{ message("fac.boo error"); browser()}
		boo
	}
	if(missing(by))
	{
		fac.boo <- get.fac.boo(x = object)
		if(sum(fac.boo) == 0)
		{
			message("aggregate not called because 'by' not specified and could not be extracted from object")
			return(object)
		}
		by <- object[, fac.boo]
		by <- if(is.data.frame(by))
			as.list(by)
		else if(is.factor(by))
			list(by)
		else
			stop("bad by")
		names(by) <- names(object)[fac.boo]
		object <- object[, !fac.boo]
	}
	if(missing(FUN)) FUN <- function(x){mean(x, na.rm = TRUE)}
	datf <- aggregate(x = object, by = by, FUN = FUN, ...)
	datf.fac.boo <- get.fac.boo(datf)
	if(sum(datf.fac.boo) >= 1)
	{
		get.rownames <- function()
		{
			paste.names <- function(...){paste(..., sep = ".")}
			nam.lis <- lapply(datf[, datf.fac.boo, drop = FALSE], as.character)
			ok <- all(sapply(nam.lis, is.character))
			if(!ok)
			{ message("get.rownames error"); browser()}
			nam <- do.call("paste.names", nam.lis)
			if(length(nam) != nrow(datf))
			{ message("nam of incorrect length"); browser()}
			nam
		}
		rownames(datf) <- get.rownames()
		datf <- datf[, !datf.fac.boo]
	}
	if(all(sapply(datf, is.numeric)))
		datf <- as.matrix(datf)
	message(dim0, " converted to ", paste.dim(datf))
	datf
})

xprnSubset <- function(object, ...){printGeneric("xprnSubset"); browser()}
removeMethods("xprnSubset")
setMethod("xprnSubset", signature(object = "ExpressionSet"), function(object, level, factor.name, ...)
{
	if(missing(factor.name))
	{
		fac.boo <- sapply(pData(object), is.factor)
		if(!any(fac.boo))
			stop("there are no factors in pData(object)")
		factor.name <- names(pData(object))[fac.boo][1]
		message("factor.name = ", factor.name)
	}
	fac <- pData(object)[, factor.name] # [,  == "MyoT"]
	stopifnot(is.factor(fac))
	if(!all(level %in% as.character(fac)))
	{ message("cannot complete xprnSubset"); browser()}
	boo <- fac %in% level
	stopifnot(sum(boo) >= 1 && length(boo) == ncol(exprs(object)))
	es <- object[, boo]
	ann <- paste(level, collapse = "&")
	annotation(es) <- if(length(annotation(es)) == 1)
		paste(ann, annotation(es), sep = " of ")
	else
		ann
	es
})
setMethod("xprnSubset", signature(object = "xprnSet"), function(object, ...)
{
	object@es <- xprnSubset(object = object@es, ...)
	object
})

unpair <- function(object, ...){printGeneric("unpair"); browser()}
removeMethods("unpair")
setMethod("unpair", signature(object = "xprnSet"), function(object, factor.name, pairing.name, change.sign, ...)
{
	if(missing(change.sign))
	{
		change.sign <- FALSE
		message("change.sign = ", change.sign)
	}
	datf <- pData(object)
	fac <- datf[, factor.name]
	stopifnot(is.factor(fac))
	levs <- levels(fac)
	stopifnot(length(levs) == 2)
	if(change.sign)
		levs <- rev(levs)
	get.pairing <- function(es)
	{
		pData(es)[, pairing.name]
	}
	get.sub <- function(level)
	{
		es <- xprnSubset(object = object, level = level, factor.name = factor.name)
		pairing <- get.pairing(es = es)
		if(any(duplicated(pairing)))
		{ message("bad pairing"); browser()}
		ord <- order(pairing)
		stopifnot(length(ord) == ncol(exprs(es)))
		es[, ord]
	}
	x <- get.sub(level = levs[1])
	y <- get.sub(level = levs[2])
	stopifnot(all(get.pairing(x) == get.pairing(y)))
	es <- x
	exprs(es@es) <- exprs(x) - exprs(y)
	pData(es@es)[, factor.name] <- factor(paste(levs, collapse = ".minus."))
	colnames(exprs(es@es)) <- rownames(pData(es@es)) <- paste(rownames(pData(x)), rownames(pData(y)), sep = ".")
	es
})
setMethod("unpair", signature(object = "XprnSet"), function(object, ...)
{
	unpair(logb(object), ...)
})

removeMissing <- function(object, ...){printGeneric("removeMissing"); browser()}
removeMethods("removeMissing")

xprnSet <- function(phenoData, exprs, ...){message("xprnSet generic"); browser()}
removeMethods("xprnSet")
setMethod("xprnSet", signature(phenoData = "AnnotatedDataFrame", exprs = "matrix"), function(phenoData, exprs, ...)
{
  ed <- new("ExpressionSet", phenoData = phenoData, exprs = exprs, ...)
  new("xprnSet", es = ed)
})
setMethod("xprnSet", signature(phenoData = "data.frame", exprs = "matrix"), function(phenoData, exprs, ...)
{
	stopifnot(ncol(exprs) == nrow(phenoData) && all(colnames(exprs) == rownames(phenoData)))
  xprnSet(phenoData = as(phenoData, "AnnotatedDataFrame"), exprs = exprs, ...)
})
setMethod("xprnSet", signature(phenoData = "missing", exprs = "matrix"), function(phenoData, exprs, ...)
{
	if(is.null(rownames(exprs)))
		rownames(exprs) <- make.names(1:nrow(exprs))
	if(is.null(colnames(exprs)))
		colnames(exprs) <- make.names(1:ncol(exprs))
	phenoData <- data.frame(dummy = factor(rep(0, ncol(exprs))))
	rownames(phenoData) <- colnames(exprs)
	xprnSet(phenoData = phenoData, exprs = exprs, ...)
})
setMethod("xprnSet", signature(phenoData = "missing", exprs = "numeric"), function(phenoData, exprs, nrow, ...)
{
	if(missing(nrow))
		nrow <- 1
	xprnSet(exprs = matrix(exprs, nrow = nrow), ...)
})
setMethod("xprnSet", signature(phenoData = "ANY", exprs = "missing"), function(phenoData, exprs, ...)
{
	xprnSet(exprs = phenoData, ...)
})


setMethod("removeMissing", signature(object = "xprnSet"), function(object)
{
  missing.gene <- as.logical(apply(exprs(object), 1, function(ro){all(is.na(ro))}))
  stopifnot(length(missing.gene) == nrow(exprs(object)))
  if(all(missing.gene))
  {
  	message("all genes are missing in ", class(object))
  	browser()
  }
  if(any(missing.gene))
  	object[!missing.gene]
  else
	  object
})

leave.out <- function(object, not.j, ...){printGeneric("leave.one.out"); browser()}
removeMethods("leave.out")
setMethod("leave.out", signature(object = "xprnSet", not.j = "Scalar"), function(object, not.j, ...)
{
	nsample <- ncol(exprs(object))
	stopifnot(nsample > 1)
	stopifnot(not.j >= 1 && not.j <= nsample)
	j <- setdiff(1:nsample, not.j)
	es <- object[, j]
	prefix <- annotation(object)
	suffix <- paste("without sample", not.j)
	annotation(es@es) <- if(is.character(prefix))
		paste(prefix, suffix)
	else
		suffix
	es
})
setMethod("leave.out", signature(object = "xprnSet", not.j = "missing"), function(object, not.j, random, ...)
{
	if(missing(random))
	{
		random <- FALSE
		message('"leave.out", signature(object = "ExpressionSet", not.j = "missing") random = ', random)
	}
	nsample <- ncol(exprs(object))
	lo <- function(not.j){leave.out(object = object, not.j = Scalar(not.j), ...)}
	if(random)
		lo(not.j = sample(1:nsample, 1))
	else
	{
		lapply(1:nsample, function(not.j){lo(not.j = not.j)})
	}
})

XprnSet <- function(phenoData, exprs, ...){message("XprnSet generic"); browser()}
removeMethods("XprnSet")
#setMethod("XprnSet", signature(phenoData = "ANY", exprs = "Matrix"), function(phenoData, exprs)
#{
#})
setMethod("XprnSet", signature(phenoData = "ANY", exprs = "matrix"), function(phenoData, exprs, ...)
{
  stopifnot(all(as.numeric(exprs) > 0, na.rm = TRUE))
#  XprnSet(phenoData = phenoData, exprs = Matrix(exprs))
  new("XprnSet", xprnSet(phenoData = phenoData, exprs = exprs, ...))
})

xprnSetPair <- function(x, y, factor.name, ...){printGeneric("xprnSetPair"); browser()}
removeMethods("xprnSetPair")
setMethod("xprnSetPair", signature(x = "xprnSet", y = "missing", factor.name = "character"), function(x, y, factor.name, level, verbose)
{
	if(missing(verbose))
		verbose <- FALSE
	fac <- pData(x)[, factor.name]
	if(!is.factor(fac)) stop("!is.factor(fac)")
	if(missing(level))
		level <- levels(unique(as.character(fac)))
	if(length(level) != 2) stop("length(level) != 2; try specifying different level argument.")
	get.subset <- function(level)
	{
		if(!all(level %in% as.character(fac)))
		{ message("cannot complete xprnSetPair"); browser()}
		if(verbose)
			message("calling xprnSubset with level = ", level, ", factor.name = ", factor.name)
		su <- xprnSubset(object = x, level = level, factor.name = factor.name)
		if(verbose)
			message("finished xprnSubset with level = ", level, ", factor.name = ", factor.name)
		su
	}
	x.sub <- get.subset(level = level[1])
	y.sub <- get.subset(level = level[2])
	xprnSetPair(x = x.sub, y = y.sub)
})
setMethod("xprnSetPair", signature(x = "xprnSet", y = "xprnSet", factor.name = "missing"), function(x, y, factor.name)
{
	if(is(x, "XprnSet") || is(y, "XprnSet"))
		stop("x, y inconsistency")
	else
		new("xprnSetPair", x = x, y = y)
})
setMethod("xprnSetPair", signature(x = "XprnSet", y = "XprnSet", factor.name = "missing"), function(x, y, factor.name, ...)
{
	xprnSetPair(x = logb(x), y = logb(y))
})
setMethod("removeMissing", signature(object = "xprnSetPair"), function(object)
{
  x <- removeMissing(object@x)
  y <- removeMissing(object@y)
  nam <- intersect(featureNames(object@x), featureNames(y))
  if(!is.character(nam) || length(nam) == 0)
  { message("x and y have no non-missing genes in common"); browser()}
  object@x <- x[nam]
  object@y <- y[nam]
  if(!validObject(object))
  { message(class(object), " is no longer valid"); browser()}
  object
})

new.xprnSetObjectPair <- function(training, test){new("xprnSetObjectPair", training = training, test = test)} # new 24 April 2008
xprnSetObjectPair <- function(x, y, ...){printGeneric("xprnSetObjectPair"); browser()}
removeMethods("xprnSetObjectPair")
setMethod("xprnSetObjectPair", signature(x = "xprnSetObject", y = "missing"), function(x, y, parametric, ...)
{
	if(missing(parametric))
	{
		parametric <- TRUE
		message("parametric = ", parametric)
	}
	get.xprnSetObject <- if(parametric)
	{
		function()
		{
			parametricBootstrap(object = x, ...)
		}
	}
	else
		function()
		{
			Sample(object = x, replace = TRUE, ...) # bootstraps microarray columns
		}
	pair <- new.xprnSetObjectPair(training = get.xprnSetObject(), test = get.xprnSetObject())
	stopifnot(is(pair, "xprnSetObjectPair"))
	pair
})

new.xprnSetObjects <- function(object) # new 28 April 2008
{
	stopifnot(is.list(object))
	if(is.null(names(object)))
		names(object) <- sapply(object, annotation)
	x <- new("xprnSetObjects", object)
	names(x) <- names(object)
	x
}

setClassUnion("xprnObject", c("xprnSet", "xprnSetPair"))

normalize <- function(object, ...){printGeneric("normalize"); browser()}
removeMethods("normalize")
setMethod("normalize", signature(object = "numeric"), function(object, na.rm, ...)
{
	if(missing(na.rm)) na.rm <- TRUE
	me <- median(object, na.rm = na.rm)
	stopifnot(is.finite(me))
	ma <- mad(object, na.rm = na.rm)
	stopifnot(ma > 0)
	(object - me) / ma
})
setMethod("normalize", signature(object = "matrix"), function(object, ...)
{
	mat <- apply(object, 2, normalize, ...)
	stopifnot(all(rownames(mat) == rownames(object)) && all(colnames(mat) == colnames(object)))
	mat
})
setMethod("normalize", signature(object = "ExpressionSet"), function(object, ...)
{
	exprs(object) <- normalize(exprs(object), ...)
	object
})
setMethod("normalize", signature(object = "xprnSet"), function(object, ...)
{
	object@es <- normalize(object = object@es, ...)
	object
})
setMethod("normalize", signature(object = "XprnSet"), function(object, ...)
{
	norm <- normalize(logb(object), ...)
	warning(paste("normalize converted ", class(object), " to ", class(norm), sep = ""))
#	stop(paste("normalize not yet implemeted for", class(object)))
	norm
})

identity <- function(x){x}



Order <- function(object, ...){message("generic Order"); browser()}
removeMethods("Order")

nondecreasing <- function(object, ...)
{
	stopifnot(is.numeric(object))
	for(j in (length(object) - 1):1)
	{
		subsequent <- object[j + 1]
		current <- object[j]
		object[j] <- if(is.na(subsequent) && is.na(current))
			as.numeric(NA)
		else
			min(subsequent, current, na.rm = TRUE)
	}
	object
}

smoothSpline <- function(x, y, ...){message("generic smoothSpline"); browser()}
removeMethods("smoothSpline")
setMethod("smoothSpline", signature(x = "numeric", y = "numeric"), function(x, y, df, nondecreasing, FUN, na.rm, ...)
{
	if(missing(na.rm))
		na.rm <- TRUE
	if(missing(nondecreasing))
	{
		nondecreasing <- FALSE
		message("nondecreasing = ", nondecreasing)
	}
	if(missing(df) && missing(FUN))
	{
		df <- 7
		message("df = ", df)
	}
	boo <- !is.na(x) & !is.na(y)
	if(!missing(df))
		stopifnot(sum(boo) >= df)
#	if(!na.rm)
#	{
#		all.x <- x
#		all.y <- y
#	}
	x <- x[boo]
	y <- y[boo]
	if(missing(FUN))
		FUN <- function(x, y, ...)
		{
			smooth.spline(x = x, y = y, df = df, ...)
		}
	ss <- FUN(x, y, ...)
	if(nondecreasing)
		ss$y <- nondecreasing(object = ss$y)
	if(!na.rm)
	{
		add.miss <- function(small)
		{
			tall <- as.numeric(rep(NA, length(boo)))
			if(length(small) != sum(boo))
				stop("add.miss error")
			tall[boo] <- small
			tall
		}
		ss$x <- add.miss(small = ss$x)
		ss$y <- add.miss(small = ss$y)
	}
	sS <- list(s3 = ss)
	new("smoothSpline", sS)
})

Lowess <- function(x, y, ...)#{printGeneric("Lowess"); browser()}
{
	if(missing(x)) stop("Lowess error")
	if(!is.numeric(x)) {message("Lowess error: x is not numeric"); browser()}
	FUN <- function(x, y, ...)
	{
		lowess(x = x, y = y, ...)
	}
	arglis <- list(x = x, FUN = FUN, ...)
	if(!missing(y)) arglis <- c(arglis, list(y = y))
	smoo <- do.call("smoothSpline", arglis)
	if(is(smoo, "smoothSpline"))
		as(smoo, "Lowess")
	else
		smoo
}
setMethod("Lowess", signature(x = "smoothSpline", y = "missing"), function(x, y, ...)
{
	arglis <- list(...)
	if(length(arglis) > 0)
	{ message("unused Lowess arguments:"); print(names(arglis)); browser()}
	as(x, "Lowess")
})
#setMethod("Lowess", signature(x = "ANY", y = "missing"), function(x, y, ...)
#{
#	Lowess(x = smoothSpline(x = x, ...))
#})
#setMethod("Lowess", signature(x = "ANY", y = "ANY"), function(x, y, ...)

movingAverage <- function(x, y, ...)#{printGeneric("movingAverage"); browser()}
{
	if(missing(x)) stop("movingAverage error")
	FUN <- function(x, y, ...)
	{
		s4 <- movingLocation(x = x, y = y, ...)
		list(x = xi(s4), y = eta(s4))
	}
	arglis <- list(x = x, FUN = FUN, ...)
	if(!missing(y)) arglis <- c(arglis, list(y = y))
	smoo <- do.call("smoothSpline", arglis)
	if(is(smoo, "smoothSpline"))
		movingAverage(x = smoo)
	else
		smoo
}
setMethod("movingAverage", signature(x = "smoothSpline", y = "missing"), function(x, y, ...)
{
	arglis <- list(...)
	if(length(arglis) > 0)
	{ message("unused movingAverage arguments:"); print(names(arglis)); browser()}
	new("movingAverage", from)
})

smoothData <- function(x, y, ...){printGeneric("smoothData"); browser()}
removeMethods("smoothData")
setMethod("smoothData", signature(x = "biasEstimate", y = "missing"), function(x, y, class2, ...)
{
	if(missing(class2))
	{
		class2 <- "Lowess"
		message("x of ", class(x), "; class2 = ", class2)
	}
	stopifnot(class2 %in% smoothData.classes)
	fu <- eval(parse(text = class2))
	if(!is.function(fu)) stop(paste("bad fu", class2))
	xvec <- Rank(x)
	yvec <- as(x, "numeric")
	if(!is.numeric(xvec) || length(xvec) != length(yvec))
	{ message("smoothData error"); browser()}
	sD <- fu(x = xvec, y = yvec, na.rm = FALSE, ...)
	if(!is(sD, class2))
	{ message("sD error"); browser()}
	if(length(xi(sD)) != length(Rank(x)) || !all(xi(sD) == Rank(x), na.rm = TRUE))
	{ message("smoothData x problem"); browser()}
	bias <- eta(sD)
	if(length(bias) != length(Rank(x)))
	{ message("smoothData y problem"); browser()}
	names(bias) <- names(x)
	if(length(annotation(x@uncorrected)) != 1)
	{ message(class(x), " annotation problem"); browser()}
	bE <- new.biasEstimate(bias = bias, uncorrected = x@uncorrected, sorted = x@sorted, jackknife = x@jackknife, Rank = x@Rank)
	smooth.ann <- try(annotation(bE), silent = TRUE)
	if(length(smooth.ann) == 0 || annotation(x) != smooth.ann)
	{
		message("smoothData bE has no annotation")
		browser()
	}
	bE
})
setMethod("smoothData", signature(x = "predictionError", y = "missing"), function(x, y, class2, ...)
{
	if(missing(class2))
	{
		class2 <- "Lowess"
		message("x of ", class(x), "; class2 = ", class2)
	}
	stopifnot(class2 %in% smoothData.classes)
	fu <- eval(parse(text = class2))
	if(!is.function(fu)) stop(paste("bad fu", class2))
	xvec <- 1:nrow(x)
	smooth.vec <- function(yvec)
	{
		if(!is.numeric(xvec) || length(xvec) != length(yvec))
		{ message(class(x), " smoothData error"); browser()}
		sD <- fu(x = xvec, y = yvec, na.rm = FALSE, ...)
		if(!is(sD, class2))
		{ message("sD error"); browser()}
		eta(sD)
	}
	x@.Data <- apply(x@.Data, 2, smooth.vec)
	stopifnot(validObject(x))
	x
})
smoothDataFUN <- function(...)
{
	function(x)
	{
		smoothData(x = x, ...)
	}
}

is.smooth <- function(object, maxDiff, verbose = FALSE)
{
	stopifnot(is.numeric(object))
	maxDiff <- Scalar(maxDiff)
	object.forward <- c(object[2:length(object)], object[length(object)])
	Diff <- abs(object.forward - object)
	if(verbose)
	{ message("maxDiff==", maxDiff, "; Diff:"); print(summary(Diff))}
	Diff <= maxDiff
}

movingLocation <- function(x, y, width, ...)
{
  message("generic movingLocation")
  browser()
}
removeMethods("movingLocation")
setMethod("movingLocation", signature(x = "ANY", y = "ANY", width = "missing"), function(x, y, width, ...)
{
	stop("width missing")
})

# methods moved to reprod.s 4 September 2007

s3 <- function(object, name){message("generic s3"); browser()}
removeMethods("s3")
s3.recursive <- function(object, name, first.call)
{
	if(missing(first.call))
		first.call <- TRUE
  x <- if(is.list(object) && "s3" %in% names(object))
    object$s3
  else if("s3" %in% slotNames(object))
    object@s3
  else if(first.call)
	  stop("s3 error")
  else
  	object
	if(first.call)
		s3.recursive(x, first.call = FALSE)
	else
		x
}
setMethod("s3", signature(object = "ANY", name = "missing"), function(object, name)
{
	s3.recursive(object = object, name = name)
})
setMethod("s3", signature(object = "ANY", name = "character"), function(object, name)
{
  s3(object)[name][[1]]
})


Slot <- function(object, name)
{
  if(name %in% slotNames(object))
    slot(object = object, name = name)
	else if((is.list(object) && "s3" %in% names(object)) || "s3" %in% slotNames(object))
		s3(object = object, name = name)
	else if(is.list(object) && name %in% names(object))
		object[name][[1]]
	else
	  stop(paste("Slot cannot extract", name, "from object of class", class(object)))
}

p.value <- function(object, ...){printGeneric("p.value"); browser()}
removeMethods("p.value")
setMethod("p.value", signature(object = "list"), function(object, ...)
{
	Slot(object = object, name = "p.value", ...)
})

xi <- function(object, ...)
{
  Slot(object = object, name = "x", ...)
}
eta <- function(object, ...)
{
  Slot(object = object, name = "y", ...)
}

Lines <- function(x, y, ...){message("generic Lines"); browser()}
removeMethods("Lines")
setMethod("Lines", signature(x = "ANY", y = "missing"), function(x, y, ...)
{
  lines(x = xi(x), y = eta(x), ...)
})
Plot <- function(x, y, ...){message("generic Plot"); browser()}
removeMethods("Plot")
setMethod("Plot", signature(x = "numeric", y = "function"), function(x, y, ...)
{
  plot(x = x, y = sapply(x, y), ...)
})
setMethod("Plot", signature(x = "ANY", y = "missing"), function(x, y, ...)
{
  plot(x = xi(x), y = eta(x), ...)
})

Character <- function(object, ...){message("generic Character"); browser()}
removeMethods("Character")
setMethod("Character", signature(object = "xprnScore"), function(object, size, ...)
{
  if(missing(size)) stop("size missing")
  arglis <- list(...)
  fun <- function(xS, ...)
  {
		stop <- length(xS)
		start <- stop - size + 1
		stopifnot(start <= stop)
  	nam <- names(do.call("sort", c(arglis, list(xS, ...)))[start:stop])
  	if(!(is.character(nam) && length(nam) == size))
  	{ message("bad nam in Union"); browser()}
  	nam
  }
	fun(object)
})

Union <- function(x, y, ...){message("generic Union"); browser()}
removeMethods("Union")
setMethod("Union", signature(x = "xprnScore", y = "xprnScore"), function(x, y, size, ...)
{
  if(missing(size)) stop("size missing")
  stopifnot(length(x) == length(y))
  fun <- function(xS){Character(object = xS, size = size, ...)}
  union(fun(x), fun(y))
})

Intersect <- function(x, y, ...){message("generic Intersect"); browser()}
removeMethods("Intersect")
setMethod("Intersect", signature(x = "xprnScore", y = "xprnScore"), function(x, y, size, ...)
{
  if(missing(size)) stop("size missing")
  stopifnot(length(x) == length(y))
  fun <- function(xS){Character(object = xS, size = size, ...)}
  intersect(fun(x), fun(y))
})

setMethod("annotation", signature(object = "ANY"), function(object)
{
  if("annotation" %in% slotNames(object))
	  object@annotation
	else
	  stop("bad annotation call")
})
setMethod("annotation", signature(object = "xprnSet"), function(object)
{
	annotation(object@es)
})


sameNames <- function(object, ...){message("generic sameNames"); browser()}
removeMethods("sameNames")
setMethod("sameNames", signature(object = "ANY"), function(object, ...)
{
	arglis <- list(...) # c(list(object), list(...))
	if("order.sensitive" %in% names(arglis))
	{
		order.sensitive <- arglis$order.sensitive
		arglis <- arglis[names(arglis) != "order.sensitive"]
		if("order.sensitive" %in% names(arglis))
		{ message("bad arglis in sameNames"); browser()}
	}
	else
		order.sensitive <- TRUE
	na.rm <- FALSE
	verbose <- FALSE
	nam0 <- names(object) # arglis[[1]])
	nam <- try(if(order.sensitive) nam0 else sort(nam0))
	if(is(nam, "try-error"))
	{
		message("nam err")
		browser()
	}
	if(verbose)
		print(nam)
	all(sapply(arglis, function(elem)
	{
	  elem.nam <- names(elem)
	  if(verbose)
	  	print(elem.nam)
	  if(!order.sensitive)
	  	elem.nam <- sort(elem.nam)
		identical(elem.nam, nam)
	}), na.rm = na.rm)
})

sameLengths <- function(...)
{
	lis <- list(...)
	all(length(lis[[1]]) == sapply(lis, length))
}

printInvalid <- function(object, ...)
{
	mess <- paste("Invalid ", class(object), ..., " on ", date(), ".", sep = "")
	message(mess)
	warning(mess)
}

printGeneric <- function(object, ...)
{
	message("Generic ", if(is.character(object)) object else class(object), ..., " on ", date(), ".")
}

subtract <- function(x, y, ...){printGeneric("subtract"); browser()}
removeMethods("subtract")

sorted <- function(object, ...)
{
	Slot(object = object, name = "sorted", ...)
}
removeMethods("sorted")

sample.size <- function(object, ...){printGeneric("sample.size"); browser()}
removeMethods("sample.size")
setMethod("sample.size", signature(object = "numeric"), function(object)
{
	sum(!is.na(object))
})
setMethod("sample.size", signature(object = "xprnSet"), function(object)
{
	mat <- exprs(object)
	size <- sapply(1:nrow(mat), function(i){sample.size(as.numeric(mat[i, ]))})
	names(size) <- featureNames(object)
	size
})

PValueFUN <- function(FUN, alternative, ...)
{
	arglis <- list(...)
	null.arg.name <- "mu"
	mu <- if(null.arg.name %in% names(arglis))
		arglis[null.arg.name][[1]]
	else
		0
	stopifnot(is.numeric(mu) && length(mu) == 1)
  if(missing(FUN))
    FUN <- t.test
  if(!is.function(FUN))
  { message("bad FUN"); browser()}
  if(missing(alternative))
  	alternative <- character(0)
  function(x, y)
  {
  	if(missing(y))
  		y <- NULL
  	insignificant.p <- if(length(alternative) == 0)
     	0.5 # 1 before 20 August 2007
    else
     	1
  	get.p <- function(alternative)
  	{
  		extract.p <- function(...){FUN(alternative = alternative, ...)$p.value}
  		if(length(alternative) == 0) # one-sided, but conservative toward 0.5 rather than toward 1
  		{
  			less <- get.p(alternative = "less")
  			greater <- get.p(alternative = "greater")
  			if(less < greater)
  				less
  			else if(greater < less)
  				1 - greater
  			else
  				insignificant.p
  		}
  		else if(is.null(y))
  			extract.p(x = x)
  		else
  			extract.p(x = x, y = y)
  	}
  	effective.sample.size <- function()
  	{
  		ss <- sample.size # function(vec){sum(!is.na(vec))}; generalized 12 May 2008
  		if(is.null(y))
  			ss(x)
  		else if(identical(FUN, wilcox.test) && min(ss(x), ss(y)) >= 1)
  			max(ss(x), ss(y))
  		else
  			min(ss(x), ss(y))
  	}
    p <- if(effective.sample.size() >= 2)
		{
			present.part <- function(vec){vec[!is.na(vec)]}
			x <- present.part(x)
			if(!is.null(y)) y <- present.part(y)
			is.essentially.constant <- function(vec){all(vec[1] == vec)}
			if(identical(FUN, t.test) && (is.essentially.constant(x) && (is.null(y) || is.essentially.constant(y))))
			{
				sample.mean <- if(is.null(y))
					x[1]
				else
					x[1] - y[1]
				if(sample.mean == mu)
					insignificant.p
				else
				{
					significant.p <- if(sample.mean > mu && length(alternative) == 0) 1 else 0 # 0 before 20 August 2007
					warning(paste("returning p-value of ", significant.p, " for ", paste(x, collapse = " | ")), " since t.test fails.", sep = "")
					significant.p
				}
			}
			else
				get.p(alternative = alternative) # typical computation of the p-value
		}
		else
			as.numeric(NA) # insignificant.p before 070828 15:57
    Scalar(p)
  }
}
RatioFUN <- function(FUN, na.rm, ...)
{
  if(missing(FUN))
    FUN <- function(x, na.rm){exp(mean(x, na.rm = na.rm))}
  if(!is.function(FUN))
  { message("bad FUN"); browser()}
  if(missing(na.rm))
    na.rm <- TRUE
  function(x)
  {
    Rat <- FUN(x, na.rm = na.rm, ...)
    Scalar(Rat)
  }
}

exp.root <- function(vec)
{
	root <- sqrt(vec)
	exp(root)
}

Mean <- function(x, na.rm, ...)
{
	if(missing(na.rm)) na.rm <- TRUE
	mean(x, na.rm = na.rm, ...)
}

Sd <- function(object, ...){printGeneric("Sd"); browser()}
removeMethods("Sd")
setMethod("Sd", signature(object = "numeric"), function(object, na.rm, mle, mu, se.of.mean)
{
	if(missing(na.rm)) na.rm <- TRUE
	if(missing(mle)) mle <- !missing(mu)
	if(missing(se.of.mean)) se.of.mean <- FALSE
	sample.mean <- mean(object, na.rm = na.rm)
	ss <- sum(!is.na(object))
	Sca <- if(ss == 0)
		as.numeric(NA)
	else if(ss == 1 && !mle && (na.rm || !any(is.na(object))))
		Inf
	else
	{
		va <- if(missing(mu) || length(mu) == 0)
			var(x = object, na.rm = na.rm)
		else
			sum((object - mu) ^ 2, na.rm = na.rm) / (ss - 1)
		if(mle)
			va <- va * (ss - 1) / ss
		sqrt(va)
	}
	if(se.of.mean)
		Sca <- Sca / sqrt(ss)
	Scalar(Sca)
})
se.mean <- function(...)
{
	Sd(..., se.of.mean = TRUE)
}

cv <- function(object, na.rm, mle, mu, ...)
{
	if(missing(na.rm))
		na.rm <- TRUE
	if(missing(mle))
		mle <- !missing(mu)
	if(missing(mu))
		mu <- numeric(0)
	mu.hat <- if(length(mu) == 0)
		mean(x = object, na.rm = na.rm)
	else
		mu
	scalar(as(Sd(object = object, na.rm = na.rm, mle = mle, mu = mu, ...), "numeric") / mu.hat)
}
functional.cv <- function(...)
{
	cv(..., mle = TRUE)
}
relativeVar <- function(...){Scalar(cv(...) ^ 2)}
functional.relativeVar <- function(...)
{
	relativeVar(..., mle = TRUE)
}
t.stat <- function(...)
{
	1 / cv(..., se.of.mean = TRUE)
}
relative.frequency <- function(x, threshold)
{
	if(missing(threshold))
		threshold <- 0
	x <- x[!is.na(x)]
	if(length(x) == 0)
		as.numeric(NA)
	else
		(sum(x > threshold) + sum(x == threshold) / 2) / length(x)
}
auc <- function(x, y, na.rm, ...)
{
	if(missing(na.rm))
		na.rm <- TRUE
	get.vec <- function(object){object[!is.na(object)]}
	x <- get.vec(x)
	y <- get.vec(y)
	if(length(x) == 0 || length(y) == 0)
		as.numeric(NA)
	else
	{
		compare <- length(x) * length(y)
		check.w <- function(w){if(w < 0 || w > 1) stop("bad w statistic")}
		get.w <- function(x, y)
		{
			options(warn = -1)
			w <- wilcox.test(x = x, y = y, na.rm = na.rm, alternative = "two.sided", ...)$statistic / compare
			options(warn = 0)
			check.w(w)
			w
		}
		ww <- get.w(x, y) # mean(get.w(x, y), 1 - get.w(y, x))
		check.w(ww)
		ww
	}
}

hsm <- function(x, na.rm) # half-sample mode of a vector [D. R. Bickel and R. Frhwirth (contributed equally), "On a Fast, Robust Estimator of the Mode: Comparisons to Other Robust Estimators with Applications," Computational Statistics and Data Analysis 50, 3500-3530 (2006)]
{
	stopifnot(is.numeric(x))
	if(missing(na.rm))
		na.rm <- FALSE
	if(na.rm)
		x <- x[!is.na(x)]
  y <- sort(x);
  while (length(y)>=4)
  {
    m <- ceiling(length(y)/2);
    w.min <- y[length(y)]-y[1];
    for(i in 1:(length(y)-m+1))
    {
      w <- y[i+m-1]-y[i];
      if(w<=w.min)
      {
        w.min <- w;
        j <- i
      }
    }
    if(w==0)
      y <- y[j]
    else
      y <- y[j:(j+m-1)]
  }
  if(length(y) == 3)
  {
    z <- 2*y[2]-y[1]-y[3];
    if(!is.finite(z))
    {
      print('ERROR: z is not finite; x, y, and z follow:');
      print(x);
      print(y);
      print(z);
    }
    if(z < 0)
      mean(y[1:2])
    else if(z > 0)
      mean(y[2:3])
    else
      y[2]
  }  
  else
    mean(y)
}

Scale <- function(object, ...){printGeneric("Scale")}
removeMethods("Scale")
Location <- function(object, ...){printGeneric("Location")}
removeMethods("Location")

oneLeftOut <- function(object, FUN, ...){message("generic oneLeftOut"); browser()}
removeMethods("oneLeftOut")
setMethod("oneLeftOut", signature(object = "numeric", FUN = "function"), function(object, FUN, ...)
{
  fun <- function(x){FUN(x, ...)}
  noneLeftOut <- list(fun(object))
  js <- 1:length(object)
  training <- lapply(js, function(j)
  {
    boo <- js != j
    stopifnot(sum(!boo) == 1 && length(boo) == length(object))
    fun(object[boo])
  })
  test <- lapply(js, function(j)
  {
    fun(object[j])
  })
  new("oneLeftOut", training = training, test = test, noneLeftOut = noneLeftOut)
})
setMethod("oneLeftOut", signature(object = "xprnSet", FUN = "function"), function(object, FUN, verbose, factor.name, ...)
{
	if(missing(verbose)) verbose <- FALSE
	if(!missing(factor.name) && is.character(factor.name) && length(factor.name) == 1) # two-sample
	{
		oneLeftOut(object = xprnSetPair(x = object, factor.name = factor.name), FUN = FUN, verbose = verbose, ...)
	}
	else if(missing(factor.name)) # single-sample; stopping condition
	{
		fun <- function(x){FUN(x, verbose = verbose, ...)} # verbose passed 31 October 2007
		noneLeftOut <- list(fun(object))
		js <- 1:ncol(exprs(object))
		training <- lapply(js, function(j)
		{
			boo <- js != j
			stopifnot(sum(!boo) == 1 && length(boo) == ncol(exprs(object)))
			fun(object[, boo])
		})
		test <- lapply(js, function(j)
		{
			fun(object[, j])
		})
		if(verbose)
		{
			message("oneLeftOut mapped ", class(object), " to ", 2 * length(training) + 1, " objects of class ", class(noneLeftOut[[1]]))
			print(FUN)
		}
		new("oneLeftOut", training = training, test = test, noneLeftOut = noneLeftOut)
	}
	else
		stop(paste("bad oneLeftOut factor.name:", factor.name))
})
setMethod("oneLeftOut", signature(object = "xprnSetPair", FUN = "function"), function(object, FUN, verbose, ...)
{
	if(missing(verbose)) verbose <- FALSE
	x <- object@x
	y <- object@y
	fun <- function(x, y)
	{
		if(missing(y))
			stop("y is missing in the two-sample case")
	  FUN(x = x, y = y, ...)
	}
	noneLeftOut <- list(fun(x = x, y = y))
	get.js <- function(object) {1:ncol(exprs(object))}
	x.js <- get.js(x)
	y.js <- get.js(y)
	training <- test <- list()
	get.es <- function(object, j, negate.j)
	{
		if(length(j) != 1) stop("bad j, get.es")
		js <- get.js(object)
		boo <- if(negate.j)
			js != j
		else
			js == j
		size <- if(negate.j)
			ncol(exprs(object)) - 1
		else
			1
		stopifnot(sum(boo) == size && length(boo) == ncol(exprs(object)))
		object[, boo]
	}
	for(x.j in x.js)
	{
		for(y.j in y.js)
		{
			if(verbose)
			{
				paste.iteration <- function(i, j){paste("(", i, ", ", j, ")", sep = "")}
				message("      objects ", paste.iteration(x.j, y.j), " of ", paste.iteration(max(x.js), max(y.js)), " began on ", date())
			}
			get.lis <- function(negate)
			{
				elem <- fun(x = get.es(object = x, j = x.j, negate = negate), y = get.es(object = y, j = y.j, negate = negate))
				ok <- is(elem, class(noneLeftOut[[1]])) && length(elem) == length(noneLeftOut[[1]])
				if(!ok){message("get.lis.elem error"); browser()}
				list(elem)
			}
			training <- c(training, get.lis(negate = TRUE))
			test <- c(test, get.lis(negate = FALSE))
			if(length(training) != length(test))
			{ message("training and test error"); browser()}
		}
	}
	if(verbose)
	{
		message("two-sample oneLeftOut mapped ", class(object), " to ", 2 * length(training) + 1, " objects of class ", class(noneLeftOut[[1]]))
		print(FUN)
	}
	olo <- try(new("oneLeftOut", training = training, test = test, noneLeftOut = noneLeftOut))
	if(is(olo, "try-error") || !validObject(olo))
	{ message('"oneLeftOut", signature(object = "xprnSetPair", FUN = "function") error'); browser()}
	olo
})
setMethod("oneLeftOut", signature(object = "oneLeftOut", FUN = "function"), function(object, FUN, ...)
{
	arglis <- list(...)
	alo.nam <- "anotherLeftOut"
	if(alo.nam %in% names(arglis))
	{
		alo <- arglis[alo.nam][[1]]
		if(!is(alo, "oneLeftOut") || length(arglis) != 1)
		{ message('cannot use "oneLeftOut", signature(object = "oneLeftOut", FUN = "function") this way'); browser()}
		# arglis <- arglis[names(arglis) != alo]
		fun <- function(x, y)
		{
			FUN(x, y)
		}
		change.lis <- function(name)
		{
			ok <- name %in% slotNames(object) && name %in% slotNames(alo)
			if(!ok){ message("change.lis error"); browser()}
			xlis <- slot(object = object, name = name)
			ylis <- slot(object = alo, name = name)
			compat <- length(xlis) == length(ylis) && sameNames(xlis, ylis)
			if(!compat)
			{ message("inner problem of oneLeftOut"); browser()}
			new.lis <- lapply(1:length(xlis), function(i)
			{
				fun(x = xlis[[i]], y = ylis[[i]])
			})
			names(new.lis) <- names(xlis)
			new.lis
		}
		training <- change.lis("training")
		test <- change.lis("test")
		noneLeftOut <- change.lis("noneLeftOut")
	}
	else
	{
		fun <- function(x){FUN(x, ...)}
		training <- lapply(object@training, fun)
		test <- lapply(object@test, fun)
		noneLeftOut <- lapply(object@noneLeftOut, fun)
	}
	len.ok <- length(training) == length(object@training) && length(test) == length(object@test) && length(noneLeftOut) == length(object@noneLeftOut)
	if(!len.ok)
	{ message("length problem in oneLeftOut"); browser()}
	new("oneLeftOut", training = training, test = test, noneLeftOut = noneLeftOut)
})

noneLeftOut <- function(object, ...){message("generic noneLeftOut"); browser()}
removeMethods("noneLeftOut")
setMethod("noneLeftOut", signature(object = "oneLeftOut"), function(object, ...)
{
  (object@noneLeftOut)[[1]]
})

sign.abs.error <- function(predicted, observed, sign.err.factor)
{
	err <- abs(predicted - observed)
	if(missing(sign.err.factor))
	{
		message("no penalty for sign errors")
		err
	}
	else
		err * ifelse(sign(predicted) * sign(observed) >= 0, 1, sign.err.factor)
}
sign.abs.error.fun <- function(sign.err.factor)
{
	function(predicted, observed){sign.abs.error(predicted = predicted, observed = observed, sign.err.factor = sign.err.factor)}
}

squaredError <- function(predicted, observed, object, ...){printGeneric("squaredError"); browser()}
removeMethods("squaredError")
setMethod("squaredError", signature(predicted = "numeric", observed = "numeric", object = "missing"), function(predicted, observed, object, relative, decay.scale)
{
	if(missing(relative)) relative <- !missing(decay.scale)
	stopifnot(is(predicted, "numeric") && is(observed, "numeric"))
	if(length(predicted) == length(observed))
		stopifnot(all(names(predicted) == names(observed)))
	else
		stopifnot(any(1 == c(length(predicted), length(observed))))
	err <- (predicted - observed) ^ 2
	if(relative)
	{
		stopifnot(length(observed) %in% c(1, length(err)))
		err <- err / observed ^ 2
	}
	if(!missing(decay.scale))
	{
		stopifnot(is.numeric(decay.scale) && length(decay.scale) %in% c(1, length(err)))
		err <- exp(- err / decay.scale)
		if(any(is.na(err)) || any(err < 0 | err > 1))
		{ message("bad err; decay.scale: ", decay.scale); browser()}
	}
	err
})

mean.squaredError <- function(...)
{
	error <- squaredError(...)
	FUN <- function(x){mean(x, na.rm = TRUE)}
	mse <- if(is.matrix(error))
		apply(error, 2, FUN)
	else if(is.numeric(error))
		FUN(error)
	if(!is.numeric(mse))
	{ message("mse is not numeric"); browser()}
	mse
}

coherence <- function(..., decay.scale) # a wrapper of squaredError
{
	if(missing(decay.scale))
	{
		decay.scale <- 1
		message("coherence decay.scale = ", decay.scale)
	}
	stopifnot(is.numeric(decay.scale) && length(decay.scale) == 1 && decay.scale > 0)
	co <- squaredError(..., relative = TRUE, decay.scale = decay.scale) # exp(-squaredError(..., relative = TRUE) / decay.scale)
	if(any(is.na(co)) || any(co < 0 | co > 1))
	{ message("coherence bad co"); browser()}
	co
}

mean.coherence <- function(..., decay.scale) # a wrapper of mean.squaredError
{
	if(missing(decay.scale))
	{
		decay.scale <- 1
		message("mean.coherence decay.scale = ", decay.scale)
	}
	stopifnot(is.numeric(decay.scale) && length(decay.scale) == 1 && decay.scale > 0)
	co <- mean.squaredError(..., relative = TRUE, decay.scale = decay.scale) # exp(-squaredError(..., relative = TRUE) / decay.scale)
	if(any(is.na(co)) || any(co < 0 | co > 1))
	{ message("mean.coherence bad co"); browser()}
	co
}

new.log <- function(old.log, base, old.base, new.base)
{
	if(missing(new.base))
		new.base <- base
	if(missing(old.base))
		old.log / logb(new.base)
	else
		old.log * logb(old.base, base = new.base)
}

sampleSize <- function(object, ...){printGeneric("sampleSize"); browser()}
removeMethods("sampleSize")

predictionError <- function(object, ...){message("generic predictionError"); browser()}
removeMethods("predictionError")
setMethod("predictionError", signature(object = "oneLeftOut"), function(object, error.fun, prediction.fun, call.Order, shrinkage, is.relative, ...)
{
	if(missing(error.fun))
	{
		error.fun.name <- "squaredError"
		error.fun <- eval(parse(text = error.fun.name))
		message("error.fun = ", error.fun.name)
	}
	stopifnot(is.function(error.fun))
	if(missing(is.relative))
	{
		is.relative <- identical(error.fun, squaredError)
		message("is.relative = ", is.relative)
	}
	nlo <- noneLeftOut(object)
	prediction.fun.stop <- function(){stop("prediction.fun should be specified as a function of a ", class(nlo), " returning a numeric.")}
	if(missing(prediction.fun))
		prediction.fun <- if(is(nlo, "estimate")) # estimate is in estimate.r
			Location
		else
			NULL
  if(is.null(prediction.fun)) # object consists of predictions
  {
  	if(!is(nlo, "numeric"))
  		prediction.fun.stop()
  	errors <- sapply(1:length(object@test), function(i)
  	{
  		error.fun(predicted = object@training[[i]], observed = object@test[[i]])
  	})
  	ef.ok <- is.matrix(errors) && ncol(errors) == length(object@test)
  	if(!ef.ok)
  	{ message("error applying error.fun"); browser()}
  	vec <- as.numeric(apply(errors, 1, mean, na.rm = TRUE))
  	stopifnot(length(vec) == length(nlo))
  	if(is.relative)
  	{
  		vec <- vec / nlo ^ 2
  		names(vec) <- names(nlo)
  	}
  	vec
  }
  else if(is.function(prediction.fun))
  {
		if(missing(call.Order))
		{
			call.Order <- TRUE
			message("call.Order = ", call.Order)
		}
		pe.vec <- function(...)
		{
			obj <- if(call.Order)
				sort(x = object, ...)
			else
				object
			predictionError(object = oneLeftOut(object = obj, FUN = prediction.fun), error.fun = error.fun, prediction.fun = NULL, call.Order = FALSE, is.relative = is.relative)
		}
		if(missing(shrinkage) && !is(nlo, "estimate"))
	  	pe.vec(...)
	  else if(!missing(shrinkage) && is(shrinkage, "numeric") && length(shrinkage) >= 1 && is(nlo, "estimate"))
	  {
	  	mat <- sapply(shrinkage, function(shri){pe.vec(shrinkage = shri, ...)})
	  	if(!is.matrix(mat))
	  		mat <- matrix(mat, ncol = 1)
	  	if(length(shrinkage) != ncol(mat))
	  	{ message("mat fails to match shrinkage"); browser()}
	  	new("predictionError", mat, parameter = shrinkage, parameter.lab = "amount of shrinkage")
	  }
	  else
	  	stop("incompatible predictionError arguments")
  }
  else
  	prediction.fun.stop()
})

accumulate <- function(object, ...){printGeneric("accumulate"); browser()}
removeMethods("accumulate")
setMethod("accumulate", signature(object = "numeric"), function(object, indices, cumulative, nfeatures, two.sided, ...)
{
	if(missing(two.sided)) two.sided <- FALSE
	if(missing(cumulative))
		cumulative <- TRUE
	if(missing(indices))
	{
		if(missing(nfeatures))
		{
			nfeatures <- length(object)
			message(class(object), " nfeatures = ", nfeatures)
		}
		indices <- 1:nfeatures
	}
	stopifnot(all(indices >= 1 & indices <= length(object)))
	vec <- if(cumulative)
		sapply(indices, function(i)
		{
			sub.indices <- if(!two.sided || i < length(object) / 2)
				1:i
			else
				i:length(object)
			mean(object[sub.indices], na.rm = TRUE)
		})
	else
		object[indices]
	if(is.character(names(object)))
		names(vec) <- names(object)[indices]
	vec
})
setMethod("accumulate", signature(object = "matrix"), function(object, ...)
{
	mat <- sapply(1:ncol(object), function(j){accumulate(object = object[, j], ...)})
#	dimnames(mat) <- dimnames(object)
	mat
})
setMethod("accumulate", signature(object = "predictionError"), function(object, ...)
{
	dn <- dimnames(object)
	mat <- accumulate(object = as(object, "matrix"), ...)
	object@.Data <- mat
#	dimnames(object) <- dn
	vo <- try(validObject(object))
	if(is(vo, "try-error") || !vo)
	{ message("vo problem"); browser()}
	object
})

moderatedT <- function(object, ...){printGeneric("moderatedT"); browser()}
removeMethods("moderatedT")

annotated <- function(object)
{
	tr <- try(annotation(object), silent = TRUE)
	tr != "try-error"
}

new.biasEstimate <- function(bias, uncorrected, sorted, jackknife, Rank, Weight) # changed 16 April 2008
{
	if(!annotated(uncorrected)){message("bad uncorrected for new.biasEstimate"); browser()}
	ann <- try(annotation(uncorrected))
	if(is(ann, "try-error")){stop("bad annotation(uncorrected)")}#; browser()}
	if(missing(Rank))
		Rank <- Numeric(numeric(0))
	stopifnot(length(names(bias)) == length(names(uncorrected)) && all(names(bias) == names(uncorrected)))
	if(missing(Weight)) Weight <- numeric(0)
	if(!is(Weight, "Scalar"))
		Weight <- Scalar(Weight)
	bE <- new("biasEstimate", bias, uncorrected = uncorrected, sorted = sorted, jackknife = jackknife, Rank = Rank, Weight = Weight)
	smooth.ann <- try(annotation(bE), silent = TRUE)
	if(length(smooth.ann) == 0)
	{
		warning("new.biasEstimate bE has no annotation")
#		browser()
	}
	bE
}
biasEstimate <- function(object, uncorrected, ...){message("generic biasEstimate"); browser()}
removeMethods("biasEstimate")
setMethod("biasEstimate", signature(object = "numeric", uncorrected = "missing"), function(object, uncorrected) # object consists of observations
{
	stop("not yet implemented for object that consists of observations rather than leave-1-out estimates")
})
setMethod("biasEstimate", signature(object = "numeric", uncorrected = "scalar"), function(object, uncorrected, jackknife)
{
	ok <- is.logical(jackknife) && length(jackknife) == 1
	if(!ok)
	{
		mess <- paste('jackknife argument must be logical of length 1 in method for class "', class(object), '"; ', 'this method is better called via the method "biasEstimate", signature(object = "estimateLeftOut") of file estimate.s', sep = '')
		stop(mess)
	}
	leave.1.out <- object[is.finite(object)]
	size <- length(leave.1.out)
	if(size == 0 || !is.finite(uncorrected))
		as.numeric(NA)
	else
	{
		sample.mean <- mean(leave.1.out, na.rm = FALSE)
		stopifnot(length(sample.mean) == 1)
		if(jackknife) # object consists of leave-1-out training-set estimates
		{
			jack.est <- (size - 1) * (sample.mean - uncorrected) # Theorem 2.1 of Efron: good for functional
			jack.est # jackknife
		}
		else # object consists of leave-1-out difference training-set estimates and test-set estimates
		{
			sample.mean # uncorrected is not used here
		}
			# jack.est * (size - 1) / size # bootstrap, Efron p. 10; cf. pp. 33-34, 44-45
	}
})
setMethod("biasEstimate", signature(object = "matrix", uncorrected = "numeric"), function(object, uncorrected, ...) # object consists of estimates
{
	stopifnot(nrow(object) == length(uncorrected))
	vec <- sapply(1:nrow(object), function(i)
	{
		biasEstimate(object = object[i, ], uncorrected = scalar(uncorrected[i]), ...)
	})
	names(vec) <- names(uncorrected)
	vec
})
setMethod("biasEstimate", signature(object = "oneLeftOut", uncorrected = "missing"), function(object, uncorrected, sorted, jackknife, ...) # object consists of ordered estimates
{
	ok <- is.logical(jackknife) && length(jackknife) == 1
	if(!ok)
	{
		mess <- paste('jackknife argument must be logical of length 1 in method for class "', class(object), '"; ', 'this method is better called via the method "biasEstimate", signature(object = "estimateLeftOut") of file estimate.s', sep = '')
		stop(mess)
	}
	if(missing(sorted))
		stop('sorted missing; this method is better called by the method "biasEstimate", signature(object = "estimateLeftOut") of file estimate.s')
	if(!sorted)
	{
		message("object of estimates is not sorted; press c to continue anyway")
		browser()
		warning("object of estimates is not sorted")
	}
#	if(missing(estimator) || !is.function(estimator))
#	{
#		stop("estimator is not the function used to generate object of ordered estimates")
#		estimator.name <- "cv"
#		estimator <- eval(parse(text = estimator.name))
#		message("estimator = ", estimator.name)
#	}
	nlo <- noneLeftOut(object)
	if(is(nlo, "numeric"))
		uncorrected <- nlo
	else	
		stop("object does not consist of numeric estimates")
	get.mat <- function(name) {sapply(slot(object, name = name), identity)}
	training.mat <- get.mat(name = "training")
	mat <- if(jackknife)
		training.mat
	else
	{
		test.mat <- get.mat(name = "test")
		stopifnot(all(dim(training.mat) == dim(test.mat)))
		training.mat - test.mat
	}
	stopifnot(nrow(mat) == length(uncorrected))
	bias <- biasEstimate(object = mat, uncorrected = uncorrected, jackknife = jackknife, ...) # as.numeric(apply(mat, 1, biasEstimate, ...))
	names(bias) <- names(uncorrected)
	new.biasEstimate(bias = bias, uncorrected = uncorrected, sorted = sorted, jackknife = jackknife)
})
setMethod("biasEstimate", signature(object = "biasEstimate", uncorrected = "missing"), function(object, uncorrected, ranks, nfeatures, use.lower.ranks, verbose, ...)
{
	total.nfeatures <- length(object)
	if(missing(verbose)) verbose <- FALSE
	if(missing(ranks))
	{
		if(missing(nfeatures))
		{
			nfeatures <- min(200, total.nfeatures)
			message("nfeatures = ", nfeatures)
		}
		if(missing(use.lower.ranks))
		{
			use.lower.ranks <- logical(0)
			message("use.lower.ranks = ", use.lower.ranks)
		}
		nf <- min(nfeatures, total.nfeatures)
		if(length(use.lower.ranks) == 0)
			nf <- ceiling(nf / 2)
		lower <- 1:nf
		upper <- (total.nfeatures + 1 - nf):total.nfeatures
		ranks <- if(length(use.lower.ranks) == 0)
			union(lower, upper)
		else if(use.lower.ranks)
			lower
		else
			upper
		if(verbose)
		{ cat("ranks = "); print(summary(ranks))}
	}
	else if(!(missing(nfeatures) && missing(use.lower.ranks)))
		stop('"biasEstimate", signature(object = "biasEstimate", uncorrected = "missing") has incompatible arguments')
	if(length(ranks) == 0 || length(ranks) > length(object))
	{ message('"biasEstimate", signature(object = "biasEstimate", uncorrected = "missing") has bad ranks'); browser()}
	stopifnot(all(ranks >= 1 & ranks <= max(Rank(object))))
	boo <- Rank(object) %in% ranks
	if(length(boo) != length(object) || sum(boo) != length(ranks))
	{ message('"biasEstimate", signature(object = "biasEstimate", uncorrected = "missing") has bad boo'); browser()}
	object[boo]
})

corrected <- function(object, ...){printGeneric("corrected"); browser()}
removeMethods("corrected")
setMethod("corrected", signature(object = "biasEstimate"), function(object)
{
	object@uncorrected - object
})

Rank <- function(object, ...){printGeneric("Rank"); browser()}
removeMethods("Rank")
setMethod("Rank", signature(object = "numeric"), function(object, factor, ...)
{
	if(missing(factor))
	{
		factor <- "warn"
		message("Rank factor = ", factor)
	}
	if(factor == "warn")
	{
		recurse <- function(factor){Rank(object = object, factor = factor, ...)}
		ra <- recurse(factor = FALSE) # no jitter
		if(all(ra == floor(ra)))
			ra
		else
		{
			warning(paste("ties broken randomly on ", date()))
			recurse(factor = 1)
		}
	}
	else
	{
		if(!is.logical(factor) || factor)
			object <- jitter(object, factor = factor)
		ra <- rank(object, ...)
		stopifnot(all(ra >= 0, na.rm = TRUE))
		Numeric(ra)
	}
})
setMethod("Rank", signature(object = "biasEstimate"), function(object)
{
	if(!object@sorted)
		stop(paste(class(object), "object is not sorted"))
	if(length(object@Rank) == 0)
	{
		vec <- Numeric(1:length(object))
		names(vec) <- names(object)
		Numeric(vec)
	}
	else
		object@Rank
})
setMethod("sort", signature(x = "biasEstimate", decreasing = "ANY"), function(x, decreasing, call.abs, save.memory, ...)
{
	ok <- is.logical(decreasing) && !decreasing
	if(!ok)
		stop(paste(class(x), "sort not implemented for non-default decreasing"))
	message('"sort", signature(x = "biasEstimate", decreasing = "missing")')
	y <- if(x@sorted)
	{
		warning(class(x), " is already sorted")
		x
	}
	else
	{
		warning("sorting ", class(x), " without additional information may be futile")
		if(missing(call.abs))
		{
			call.abs <- FALSE
			message("sort call.abs = ", call.abs)
		}
		if(missing(save.memory))
		{
			save.memory <- length(x >= 1e5)
			message("sort ", class(x), " save.memory = ", save.memory)
		}
		object <- x@uncorrected
		if(call.abs)
			object <- abs(object)
		message("Ranking ", class(x), " by", if(call.abs) " abs of " else " ","its ", class(object), " on ", date())
		ra <- Rank(object = object, ...)
		x@sorted <- TRUE
		if(any(is.na(ra)))
		{ message("missing rank value"); browser()}
		ord <- order(ra, decreasing = decreasing)
		sorted.ra <- ra[ord]
		stopifnot(all(sorted.ra == (1:length(ra))))
		if(!save.memory)
			x@Rank <- sorted.ra
		sort.slot <- function(name)
		{
			value <- slot(object = x, name = name)
			stopifnot(length(value) == length(ord))
			value[ord]
		}
		nam <- names(x)
		if(is.character(nam))
			nam <- nam[ord]
		x@.Data <- sort.slot(name = ".Data")
		stopifnot(length(x) == length(nam))
		names(x) <- nam
		x@uncorrected <- sort.slot(name = "uncorrected")
		stopifnot(validObject(x))
		x
	}
	stopifnot(y@sorted)
	y
})

blank.plot <- function(...)
{
	plot(x = 0, type = "n", col.axis = "white", xlab = "", ylab = "", tcl = 0, xaxt = "n", yaxt = "n", bty = "n", ...)
}
 
# Sample moved from reprod.s & numeric method added on 24 October 2007:
Sample <- function(object, ...){printGeneric("Sample"); browser()}
removeMethods("Sample")
setMethod("Sample", signature(object = "numeric"), function(object, ...)
{
	sample(x = object, ...)
})
setMethod("Sample", signature(object = "ExpressionSet"), function(object, ...)
{
	object[, Sample(1:ncol(exprs(object)), ...)] # sample
})
setMethod("Sample", signature(object = "xprnSet"), function(object, ...)
{
	object@es <- Sample(object@es, ...)
	object
})
setMethod("Sample", signature(object = "xprnSetPair"), function(object, ...) # new 25 April 2008
{
	sample.es <- function(es){Sample(object = es, ...)}
	object@x <- sample.es(es = object@x)
	object@y <- sample.es(es = object@y)
	stopifnot(validObject(object))
	object
})

mean.and.sd <- function(object, i) # not for the user
{
	if(is(object, "XprnSet"))
		object <- logb(object)
	stopifnot(is(object, "xprnSet"))
	if(missing(i))
	{
		i <- 1:10
		cat("i = "); print(i)
	}
	object <- object[i, ]
	apply(exprs(object), 1, function(ro){c(mean = mean(ro, na.rm = TRUE), sd = sd(ro, na.rm = TRUE))})
}
plot.mean.and.sd <- function(object, i, ...) # not for the user
{
	stopifnot(is(object, "list"))
	if(missing(i))
	{
		i <- 1:100
		cat("i = "); print(i)
	}
	mats <- lapply(object, function(es){mean.and.sd(object = es, i = i)})
	histogram <- length(i) >= 20
	if(length(i) <= 10) print(mats)
	plot.moment <- function(moment.name)
	{
		moments.mat <- sapply(mats, function(mat){mat[moment.name, ]})
		colnames(moments.mat) <- names(mats)
		get.y <- function(j){moments.mat[, j]}
		cat("\n", moment.name, " diagnostics for ", length(i), " genes:\n", sep = "")
		print.diagnostics <- function(reference.name, mat.name)
		{
			mat.minus.reference <- if(mat.name == "sd")
			{
				get.y(j = mat.name) ^ 2 - get.y(j = reference.name) ^ 2
				mat.name <- "var"
			}
			else
				get.y(j = mat.name) - get.y(j = reference.name)
			diff.name <- paste(mat.name, " minus ", reference.name, sep = "")
			message(diff.name, ":")
			print(summary(mat.minus.reference))
			print.portion <- function(ineq)
			{
				boo <- if(ineq == "less")
					mat.minus.reference < 0
				else if(ineq == "greater")
					mat.minus.reference > 0
				boo <- boo[!is.na(boo)]
				message(round(sum(boo) * 100, 1) / length(boo), "% are ", ineq, " than 0")
			}
			print.portion("less")
			print.portion("greater")
			if(histogram) hist(mat.minus.reference, xlab = diff.name, main = moment.name)
		}
		get.name <- function(index){names(mats)[index]}
		reference.index <- 1
		ylim <- range(as.numeric(moments.mat), na.rm = TRUE)
		for(index in 1:length(object))
		{
			if(index != reference.index)
			{
				print.diagnostics(reference.name = get.name(index = reference.index), mat.name = get.name(index = index))
			}
			graph <- function(fun, ...)
			{
				x <- i
				y <- get.y(j = index) # mats[[index]][moment.name, ]
				if(length(x) != length(y))
				{ message("bad news"); browser()}
				fun(x = x, y = y, ...)
			}
			if(!histogram)
				graph(fun = if(index == 1) function(...){plot(main = "diagnostics", xlab = "index", ylab = moment.name, ylim = ylim, ...)} else points, pch = index, col = index, ...)
		}
		if(!histogram) legend(legend = names(object), x = "topleft", pch = i, col = i)
	}
	par(mfrow = c(2, 2))
	plot.moment(moment.name = "mean")
	plot.moment(moment.name = "sd")
}

parametricBootstrap <- function(object, ...){printGeneric("parametricBootstrap"); browser()}
removeMethods("parametricBootstrap")
setMethod("parametricBootstrap", signature(object = "numeric"), function(object, ...)
{
	sample.mean <- mean(object, na.rm = TRUE)
	sample.sd <- Sd(object, mle = FALSE, na.rm = TRUE) # sd(object, na.rm = TRUE) changed 25 and 28 (before 6:00 pm) April 2008 (cf. pp. 7, 9 of Peter Hall)
	normality.failed <- !is.finite(sample.mean) || !is.finite(sample.sd) || sample.sd == 0
	get.vec <- function()
	{
		num <- object
		boo <- !is.na(num)
		bootstrap.sample <- if(normality.failed)
		{
			function(n)
			{
				warning("missing bootstrap values returned")
				as.numeric(rep(NA, n)) # this might be replaced by a nonparametric bootstrap
			}
		}
		else
		{
			function(n)
			{
				rnorm(mean = sample.mean, sd = sample.sd, n = n) # added 28 April 2008
			}
		}
		num[boo] <- bootstrap.sample(n = sum(boo)) # added 28 April 2008
		num
	}
	vec <- get.vec()
	stopifnot(length(vec) == length(object))
	names(vec) <- names(object)
#	if(normality.failed)
#		stopifnot(all(is.na(vec)))
	if(!normality.failed && !all(is.na(vec) == is.na(object)))
	{
		message("bad vec")
		browser()
	}
	vec
})
setMethod("parametricBootstrap", signature(object = "matrix"), function(object, ...)
{
	mat <- t(sapply(1:nrow(object), function(i)
	{
		parametricBootstrap(object = object[i, ], ...)
	}))
	stopifnot(all(dim(mat) == dim(object)))
	rownames(mat) <- rownames(object)
	colnames(mat) <- colnames(object)
	mat
})
setMethod("parametricBootstrap", signature(object = "ExpressionSet"), function(object, ...)
{
	exprs(object) <- parametricBootstrap(exprs(object))
	object
})
setMethod("parametricBootstrap", signature(object = "xprnSet"), function(object, ...)
{
	object@es <- parametricBootstrap(object@es, ...)
	object
})
setMethod("parametricBootstrap", signature(object = "XprnSet"), function(object, ...)
{
	parametricBootstrap(logb(object), ...)
})
setMethod("parametricBootstrap", signature(object = "xprnSetPair"), function(object, ...)
{
	get.es <- function(es){parametricBootstrap(es)}
	new("xprnSetPair", x = get.es(es = object@x), y = get.es(es = object@y))
})

beep <- function(n, pause)
{
	if(missing(n))
		n <- 1
	if(missing(pause))
	{
		pause <- if(n == 1)
			0
		else
			1e7
	}
	for(i in 1:n)
	{
		if(i > 1)
		{
			for(j in 1:pause)
				"a"
		}
		alarm()
	}
}

Combine <- function(x, y, ...){printGeneric("Combine"); browser()}
removeMethods("Combine")
setMethod("Combine", signature(x = "numeric", y = "numeric"), function(x, y, ...)
{
	c(x, y, ...)
})
setMethod("Combine", signature(x = "Numeric", y = "Numeric"), function(x, y, ...)
{
	num <- function(object){as(object, "numeric")}
	Numeric(Combine(x = num(x), y = num(y), ...))
})

zplot <- function(x, y, ...){printGeneric("zplot"); browser()} # new 25 April 2008
removeMethods("zplot")
setMethod("zplot", signature(x = "Fdr", y = "missing"), function(x, y, ...)
{
	get.lab <- function(prefix){paste(prefix, "(z space)")}
	plot(zvalue(x, type = "pvalue"), zvalue(x, type = "fdr"), xlab = get.lab(prefix = "p-value"), ylab = get.lab(prefix = "local false discovery rate"), ...)
	abcol <- "gray"
	abline(v = 0, col = abcol)
	abline(h = 0, col = abcol)
})
setMethod("zplot", signature(x = "Prob0", y = "missing"), function(x, y, ...)
{
	zplot(x = as(x, "Fdr"), ...)
})

Smooth <- function(object, smooth, f) # in "plot", signature(x = "numeric", y = "biasEstimate") before 9 May 2008
{
	stopifnot(is(object, "biasEstimate"))
	if(missing(smooth) || is.null(smooth))
	{
		smooth <- TRUE
		message("smooth = ", smooth)
	}
	if(!is.logical(smooth) || smooth)
	{
		if(!is.function(smooth))
		{
			if(missing(f) || is.null(f))
			{
				f <- 1 / 100
				message("f = ", f)
			}
			smooth <- smoothDataFUN(f = f) # smoothData
			message("smooth = [default function]")
		}
		ann <- annotation(object)
		object <- smooth(object)
		if(!is(object, "biasEstimate")) stop("smooth object lost its class")
		smooth.ann <- try(annotation(object), silent = TRUE)
		if(length(smooth.ann) == 0 || ann != smooth.ann) stop("smooth object lost its annotation, ", ann)
	}
	object
}

Domain <- function(object, ...){printGeneric("Domain"); browser()}
removeMethods("Domain")
setMethod("Domain", signature(object = "Density"), function(object, ...)
{
	den <- s3(object)
	x <- den$x[is.finite(den$x)]
	dom <- range(x, na.rm = TRUE)
	ok <- is.numeric(dom) && length(dom) == 2 && dom[1] < dom[2]
	if(!ok)
	{ message("bad Domain"); browser()}
	dom
})
Range <- function(object, ...){printGeneric("Range"); browser()}
removeMethods("Range")
setMethod("Range", signature(object = "Density"), function(object, positive, ...)
{
	den <- s3(object)
	y <- den$y[is.finite(den$y)]
	if(positive)
		y <- y[y > 0]
	ra <- range(y, na.rm = TRUE)
	ok <- is.numeric(ra) && length(ra) == 2 && ra[1] < ra[2]
	if(!ok)
	{ message("bad Range"); browser()}
	ra
})

new.Density <- function(s3, ann, ...)
{
	if(length(s3) > 1)
		s3 <- list(s3 = s3)
	new("Density", s3 = s3, annotation = ann, ...)
}
Density <- function(x, ...){printGeneric("Density"); browser()}
removeMethods("Density")
setMethod("Density", signature(x = "numeric"), function(x, ann, ...)
{
	s3 <- density(x = x[is.finite(x)], ...)
	if(missing(ann))
	{
		ann <- try(annotation(x))
	}
	if(is(ann, "try-error"))
	{
		ann <- date()
		message("Density ann = ", ann)
	}
	new.Density(s3 = s3, ann = ann)
})

new.functions <- function(object)
{
	if(is(object, "function"))
		functions(object)
	else if(is.list(object))
	{
		funs <- new("functions", object)
		names(funs) <- names(object)
		funs
	}
	else
		stop("new.functions error")
}
functions <- function(...)
{
	lis <- list(...)
	if(length(lis) == 0 || is(lis[[1]], "function"))
		new.functions(lis)
	else if(is(lis[[1]], "list"))
		new.functions(...)
	else
		stop("functions error")
}

closest <- function(object, target, ...){printGeneric("closest"); browser()}
removeMethods("closest")
setMethod("closest", signature(object = "numeric", target = "numeric"), function(object, target)
{
	if(length(object) == 1 && length(target) > 1)
		closest(target, object)
	else if(length(target) == 1)
	{
		dis <- abs(object - target)
		boo <- dis == min(dis, na.rm = TRUE)
		boo <- boo & !is.na(boo)
		if(is.null(names(object)))
			names(object) <- as.character(which(boo))
		object[boo]
	}
	else if(length(target) > 1)
	{
		sapply(target, closest, object = object)
	}
	else
		stop("bad closest")
})

test <- function(object, ...){printGeneric("test"); browser()}
removeMethods("test")

setSeed <- function(seed, kind = "Knuth-TAOCP-2002")
{
	if(missing(seed) || length(seed) == 0 || is.null(seed))
	{
		seed <- round(1000 * runif(1), 0) + 1
		message("setSeed seed = ", seed)
	}
	set.seed(seed = seed, kind = kind)
}
seed.random <- function(...){message("calling setSeed"); setSeed(...)}

memory <- function(x, bytes, total.only, verbose)
{
	nam <- slotNames(x)
	if(missing(verbose))
	{
		verbose <- TRUE
		if(verbose)
			message("verbose = ", verbose)
	}
	if(missing(total.only))
	{
		total.only <- FALSE
		if(verbose && is.character(nam))
			message("total.only = ", total.only)
	}
	if(missing(bytes))
		bytes <- 1e6
	if(verbose && bytes == 1e6)
		message("object sizes given in MB")
	else if(verbose && bytes == 1e9)
		message("object sizes given in GB")
	lis <- list(total = round(object.size(x) / bytes, 1))
	if(!total.only && is.character(nam) && lis[[1]] >= 1)
	{
		lis2 <- lapply(nam, function(name)
		{
			memory(slot(x, name = name), bytes = bytes, total.only = total.only, verbose = FALSE)
		})
		stopifnot(length(lis2) == length(nam))
		names(lis2) <- nam
		lis <- c(lis, lis2)
	}
	lis
}

Verbose <- FALSE
Sum <- function(object, ...){printGeneric("Sum"); browser()}
removeMethods("Sum")
setMethod("Sum", signature(object = "numeric"), function(object, na.rm)
{
	if(missing(na.rm))
		na.rm <- TRUE
	fun <- function(...){sum(..., na.rm = na.rm)}
	do.call("fun", as.list(object))
})
Sum.list <- function(object)
{
	if(Verbose)
		message("calling Sum.list for ", length(object), " elements each of class ", class(object[[1]]))
	tot <- if(length(object) == 1)
		object[[1]]
	else if(length(object) > 1)
		try(object[[1]] + Sum(object[2:length(object)]))
	else
		stop("Sum error 1")
	if(is(tot, "try-error"))
	{ message("Sum error 2"); browser()}
	tot
} # setMethod("Sum", signature(object = "list"), Sum.list)
setMethod("Sum", signature(object = "list"), function(object, na.rm)
{
	if(missing(na.rm))
		na.rm <- FALSE
	if(na.rm)
		object <- object(!is.na(object))
	tot <- object[[1]]
	for(i in 2:length(object))
		tot <- tot + object[[i]]
	tot
})

#bind <- function(x, y, ...)
#{
#	printGeneric("bind")
#}
removeMethods("merge")
setMethod("merge", signature(x = "numeric", y = "numeric"), function(x, y)
{
	vec <- c(x, y)
	if(is.character(names(vec)) && any(duplicated(names(vec))))
	{
		warning("making names unique")
		names(vec) <- make.names(names(vec), unique = TRUE)
	}
	vec
})
setMethod("merge", signature(x = "matrix", y = "matrix"), function(x, y, MARGIN, ...)
{
	fun <- if(MARGIN == 1)
		rbind
	else if(MARGIN == 2)
		cbind
	else
		stop("bad MARGIN")
	mat <- fun(x, y, ...)
	namfun <- if(MARGIN == 1)
		rownames
	else if(MARGIN == 2)
		colnames
	else
		stop("bad MARGIN 2")
	if(is.character(namfun(mat)) && any(duplicated(namfun(mat))))
	{
		warning("making dimnames unique")
		dimnames(mat)[[MARGIN]] <- make.names(namfun(mat), unique = TRUE)
	}
	mat
})

geomean <- function(x, ...){exp(mean(x = logb(x), ...))}

swap <- function(object, ...){printGeneric("swap"); browser()}
removeMethods("swap")

in.interval <- function(x, lim, lower, upper, call.abs) # generalized 081002
{
	if(missing(call.abs))
	{
		call.abs <- FALSE
		message("in.interval call.abs = ", call.abs)
	}
	assert.is(call.abs, "logical")
	if(call.abs)
		x <- abs(x)
	if(missing(lim))
	{
		assert.is(lower, "numeric")
		assert.is(upper, "numeric")
		is.len.ok <- function(vec){length(vec) %in% c(1, length(x))}
		stopifnot(is.len.ok(lower) && is.len.ok(upper))
		x >= lower & x <= upper
	}
	else if(missing(lower) && missing(upper))
	{
		stopifnot(length(lim) == 2 && lim[1] <= lim[2])
		in.interval(x = x, lower = lim[1], upper = lim[2], call.abs = call.abs)
	}
	else
	{ message("bad argument combination"); browser()}
}

assert.is <- function(object, class2)
{
	if(!is(object = object, class2 = class2))
		stop(paste("got", class(object), "when", class2, "was required"))
}
assert.are <- function(object, class2)
{
	assert.is(object, "list")
	for(obj in object)
		assert.is(object = obj, class2 = class2)
}

argmax <- function(object, from, to, length.out, length.multiplier, max.relevant, tolerance, max.iter, max.length)
{
	assert.is(argmax, "function")
	if(missing(length.out))
		length.out <- 100
	assert.is(length.out, "numeric")
	if(missing(length.multiplier))
		length.multiplier <- 5
	if(missing(max.length))
		max.length <- 10 ^ 12
	if(missing(max.iter))
		max.iter <- min(1000, floor(log(max.length / length.out) / log(length.multiplier)))
	if(missing(max.relevant) || length(max.relevant) == 0)
		max.relevant <- Inf
	if(missing(tolerance) || length(tolerance) == 0)
		stop("tolerance missing")
	assert.are(list(from, to, length.multiplier, length.out, max.iter, max.relevant, tolerance), "numeric")
	if(any(is.na(c(from, to))) || from > to)
	{ message("bad from, to"); browser()}
	get.argmax <- function(length.out)
	{
		if(length.out > max.length)
		{ message("length.out too high"); browser()}
		argvec <- seq(from = from, to = to, length.out = length.out)
		mapped <- object(argvec)
		if(any(is.na(mapped)))
		{
			message("bad mapped")
			browser()
		}
		boo <- mapped == max(mapped)
		if(!any(boo))
		{ message("no max."); browser()}
		if(sum(boo) != 1)
		{ message("no unique max."); browser()}
		argvec[boo]
	}
	old.argmax <- new.argmax <- get.argmax(length.out = length.out)
	iter <- 1
	is.iter.low <- function(iter){iter <= max.iter}
	low.iter <- is.iter.low(iter = iter)
	while(low.iter && object(new.argmax) < max.relevant && (iter == 1 || abs(object(new.argmax) - object(old.argmax)) > tolerance))
	{
		old.argmax <- new.argmax
		new.argmax <- get.argmax(length.out = length.out * length.multiplier)
		iter <- iter + 1
		low.iter <- is.iter.low(iter = iter)
	}
	if(!low.iter)
	{	message("exited because exceeded ", max.iter, " iterations"); browser()}
	new.argmax[1]
}

overload <- function(f, ...)
{
	assert.is(f, "character")
	if(isGeneric(f, ...))
		stop(paste(f, "is generic and thus cannot be overloaded"))
	else
	{
		fun <- eval(parse(text = f))
		if(!is(fun, "function"))
			stop(paste(f, "does not exist and thus cannot be overloaded"))
		fun
	}
}

check.overload <- function(...)
{
	lis <- list(...)
	if(length(lis) >= 2)
	{
		if(any(sapply(lis[2:length(lis)], function(fun)
		{
			assert.is(fun, "function")
			identical(fun, lis[[1]])
		})))
			stop("overload error; try calling Sour(..., reload = TRUE)")
	}
	else
		stop("check.overload has less than 2 arguments")
}

impute <- function(object, ...) # for Bioinformatics revision of 15 Oct. 2008
{
	rule <- 2
	neighbors.equal <- TRUE
	if(neighbors.equal)
		warning("nonstandard linear imputation; consider changing impute function")
	if(is(object, "xprnSet"))
	{
		mat <- impute(exprs(object), ...)
		tr <- try(exprs(object@es) <- mat)
		if(is(tr, "try-error"))
		{ message("bad exprs assignment"); browser()}
		object
	}
	else if(is(object, "matrix"))
	{
		for(i in 1:nrow(object))
			object[i, ] <- impute(object[i, ], ...)
		object
	}
	else if(is(object, "numeric"))
	{
		x <- 1:length(object)
		y <- object
		boo <- is.finite(y)
		if(sum(boo) < 2)
		{
			replacement <- 0
			warning(paste("replacing all values with", replacement))
			return(rep(0, length(object)))
		}
		fun <- try(approxfun(x = x[boo], y = y[boo], rule = rule))
		if(is(fun, "try-error"))
		{ message("error"); browser()}
		imputed <- fun(x)
		is.ok <- function(vec){all(is.finite(vec) & (!is.finite(y) | vec == y))}
		ok <- is.ok(vec = imputed)
		if(!ok)
		{ message("imputation error"); browser()}
		if(neighbors.equal)
		{
#			z <- object
			adjusted <- imputed
			j <- 2
			while(j < length(y))
			{
				k <- j + 1
				while(!is.finite(y[j]) && !is.finite(y[k]) && k < length(y))
				{
					adjusted[j:k] <- mean(imputed[j:k])
					k <- k + 1
				}
				stopifnot(is.finite(y[k]) || is.finite(y[j]) || k == length(y))
				j <- k
			}
			ok <- is.ok(vec = adjusted)
			if(!ok)
			{ message("adjustment error"); browser()}
			adjusted
		}
		else
			imputed
	}
	else
		stop("bad object class")
}

default <- function(object, name, verbose, return.value = object)
{
	if(missing(verbose))
		verbose <- TRUE
	if(verbose)
	{
		if(missing(name))
			name <- "actual argument"
		stopifnot(length(name) == 1 && is.character(name))
		prefix <- paste(name, "was set to default value of ")
		suffix <- paste(" on ", date(), ".", sep = "")
		if(length(object) == 1 && (is(object, "character") || is(object, "numeric")))
			message(prefix, object, suffix)
		else
		{
			cat("\n", prefix)
			print(object)
			cat(paste(suffix, "\n\n"))
		}
	}
	return.value
}

defaultFUN <- function(object, ...)
{
	return.value <- if(is(object, "character"))
	{
		eval(parse(text = object))
	}
	else if(is(object, "function"))
		object
	if(is(object, "character"))
		object <- paste("function of name", object)
	if(is(return.value, "function") || is(return.value, "sampleFunction") || is(return.value, "sampleFunctions"))
		default(object = object, return.value = return.value, ...)
	else 
		stop(paste("return.value is ", class(return.value), ", not a function", sep = ""))
}

export <- function(object, ...)
{
# printGeneric("export"); browser()
	datf <- as(object, "data.frame")
	if(is.data.frame(datf))
		export(object = datf, ...)
	else
	{ message("cannot coerce ", class(object), " to data frame"); browser()}
}
removeMethods("export")
setMethod("export", signature(object = "data.frame"), function(object, file, ...)
{
	if(missing(file))
		file <- paste("exported ", Sys.Date(), ".csv", sep = "")
	write.csv(x = object, file = file, ...)
})

