aboutBickelPackages="BickelPackages, Version 2.3. Copyright (c) 1998-2003 by David R. Bickel.
\n
The contents of these files are subject to the Mozilla Public License Version 1.1 (the \"License\"); you may not use these files except in compliance with the License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
\n
Software distributed under the License is distributed on an \"AS IS\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the specific language governing rights and limitations under the License.
\n
Type technicalSupport for the author's contact information.";

Print[aboutBickelPackages];

technicalSupport="
To request limited technical support, contact the author of the packages:\n
\n
David R. Bickel, PhD\n
E-mail:  bickel@prueba.info\n
URL: davidbickel.com\n
\n
David R. Bickel created the first package of 'BickelPackages' in 1998 at the University of Texas Health Science Center at Houston, where he has made modifications to the packages as late as March 16, 2001. Subsequent modifications were made at the Medical College of Georgia.
";

(* 3/15/01, 5/17/02 licenseAgreement, aboutBickelPackages, and technicalSupport modified.*)
(* 2/15/01 firstDifference, mapToSubseries, nthLowest, and nthHighest fcns added.*)
(*12/21/00 period added from "BickelPackages`NonlinearFitSupplement`".*)
(* 9/19/00 sampleTime[] and traceQ added.*)
(* 9/ 1/00 nSecondDerivative[] added and nDerivative[] made about twice as time-efficient.*)
(* 8/ 7/00 nDerivative[] added.*)
(* 5/19/00 firstPosition[] added.*)
(* 9-15-99 unequalPartition[] added.*)
(* 9- 1-99 function(s) related to firstOrderKurtosis[] added.*)
(* 9- 1-99 BickelPackages`Common` created by David Bickel.*)

BeginPackage["BickelPackages`Common`"]

robustKurtosis::usage="robustKurtosis[someData_?VectorQ] returns the sample estimate of second-order kurtosis.
	robustKurtosis[pdf] returns the second-order kurtosis of a symmetric, zero-centered PDF.
	robustKurtosis[distribution] returns the second-order kurtosis of a distribution."

robustKurtosisExcess::usage="robustKurtosisExcess[someData_?VectorQ] returns the sample estimate of excess robust kurtosis.
	robustKurtosisExcess[pdf] returns the excess robust kurtosis of a symmetric, zero-centered PDF, which is 0 for a normal distribution.
	robustKurtosisExcess[distribution] returns the second-order kurtosis of a distribution, relative to the normal distribution."

firstOrderKurtosis::usage="robustKurtosis[someData_?VectorQ] returns the sample estimate of first-moment kurtosis.
	firstOrderKurtosis[distribution] returns the first-moment kurtosis of a distribution, relative to the uniform distribution."

firstOrderKurtosisExcess::usage="robustKurtosisExcess[someData_?VectorQ] returns the sample estimate of excess first-moment kurtosis, which is 0 for a uniform distribution.
	firstOrderKurtosisExcess[distribution] returns the first-moment kurtosis of a distribution, relative to the uniform distribution."

meanDeviation::usage="meanDeviation[list or distribution] returns the mean absolute deviation from the median, as per p. 611 of Numerical Recipes."

unequalPartition::usage="unequalPartition[someData_?VectorQ, dividingIndices_?VectorQ] divides someData into parts separated by dividingInides {di1,di2,...}, where di1 is the element number of the last entry of sublist #1, di2 is that of sublist #2, etc."

firstPosition::usage="firstPosition[argumentsForPosition___] returns the first number returned by Position[argumentsForPosition]."

nDerivative::usage="nDerivative[fcnOfOneArg_, argOfEvaluation_?NumberQ, opts___Rule] and nDerivative[fcnOfOneArg_, {argOfEvaluation_?NumberQ, initialArg_?NumberQ}, opts___Rule] numerically compute the derivative of fcnOfOneArg with respect to argOfEvaluation, using finiteDifference[]."

nSecondDerivative::usage="nSecondDerivative[fcnOfOneArg_, argOfEvaluation_?NumberQ, opts___Rule] and nSecondDerivative[fcnOfOneArg_, {argOfEvaluation_?NumberQ, initialArg_?NumberQ}, opts___Rule] numerically compute the second derivative of fcnOfOneArg with respect to argOfEvaluation, using finiteSecondDifference[]."

finiteDifference::usage="finiteDifference[fcnOfOneArg_, fcnAtArgOfEvaluation_?NumberQ, argOfEvaluation_?NumberQ, currentArg_?NumberQ] returns that which nDerivative takes to a limit."

finiteSecondDifference::usage="finiteSecondDifference[fcnOfOneArg_, fcnAtArgOfEvaluation_?NumberQ, argOfEvaluation_?NumberQ, argDiff_?NumberQ, opts___Rule] returns that which nSecondDerivative takes to a limit."

sampleTime::usage="sampleTime[timeSeries_?MatrixQ] returns the time between observations in timeSeries, which is in the format {{t0,x1},{t0+sampleTime,x2},{t0+2*sampleTime,x3},...}."

firstDifference::usage="firstDifference[someData_?VectorQ] returns the first difference of the argument and firstDifference[someData_?MatrixQ] returns the first difference of the dependent variable versus the independent variable."

mapToSubseries::usage="mapToSubseries[fcnOfVector_, dataVsTime_?MatrixQ, timePerSubseries_?NumberQ] returns a vector of values returned by fcnOfVector of the data in each subseries."

nthLowest::usage="nthLowest[someData_?VectorQ, n_?IntegerQ] returns the nth lowest value of someData."

nthHighest::usage="nthHighest[someData_?VectorQ, n_?IntegerQ] returns the nth highest value of someData."

linkUNIX::usage = "linkUNIX[] returns the path of the current notebook with the UNIX open command."




traceQ::usage="Set to True to print variables."
period::usage="Parameter of cosine[time,{amplitude,period,timePhase,mesor}] or a more general time for one complete cycle."



Options[firstPosition]=Options[Position]
Options[nSecondDerivative] = Options[nDerivative] = {MaxIterations -> 30, maxError -> 10^(-10), traceQ -> False}
Options[finiteSecondDifference] = {traceQ -> False}




Begin["`Private`"]

robustKurtosisExcess[x_] := robustKurtosis[x] - Pi/2

firstOrderKurtosisExcess[x_] := firstOrderKurtosis[x] - 1

unequalPartition[someData_?VectorQ, dividingIndices_?VectorQ] :=
  Table[
      Table[
        someData[[j]],
        {j, If[i == 1, 1, dividingIndices[[i - 1]] + 1], 
          If[i == Length[dividingIndices] + 1, Length[someData], 
            dividingIndices[[i]]]}
        ],
      {i, Length[dividingIndices] + 1}
      ] /; (Min[dividingIndices] >= 0 && 
        Max[dividingIndices] <= Length[someData])

firstPosition[argumentsForPosition___] := 
  First[Flatten[Position[argumentsForPosition]]]

finiteDifference[fcnOfOneArg_, fcnAtArgOfEvaluation_?NumberQ, argOfEvaluation_?NumberQ, currentArg_?NumberQ] := (fcnOfOneArg[currentArg] - 
        fcnAtArgOfEvaluation)/(currentArg - argOfEvaluation)

finiteSecondDifference[fcnOfOneArg_, fcnAtArgOfEvaluation_?NumberQ, argOfEvaluation_?NumberQ, argDiff_?NumberQ, opts___Rule] :=
  Module[
    {fPlus = fcnOfOneArg[argOfEvaluation + argDiff], 
      fMinus = fcnOfOneArg[argOfEvaluation - argDiff], tempReturn},
    tempReturn = (fPlus + fMinus - 2*fcnAtArgOfEvaluation)/argDiff^2;
    If[(traceQ /. {opts} /. Options[finiteSecondDifference]), 
      Print["(", fPlus, "+", fMinus, "-2*", fcnAtArgOfEvaluation, ")/", argDiff, "^2==", 
        tempReturn]];
    tempReturn
    ]

nDerivative[fcnOfOneArg_, {argOfEvaluation_?NumberQ, initialArg_?NumberQ}, 
    opts___Rule] := 
  Module[{closeEnough = False, numIter = 0, 
      maxNumIter = (MaxIterations /. {opts} /. Options[nDerivative]), 
      maxErr = (maxError /. {opts} /. Options[nDerivative]), 
      isTracing = (traceQ /. {opts} /. Options[nDerivative]), newDiff, 
      oldDiff, currentArg = initialArg, error, 
      fcnAtArgOfEvaluation = fcnOfOneArg[argOfEvaluation]}, 
    newDiff = 
      finiteDifference[fcnOfOneArg, fcnAtArgOfEvaluation, argOfEvaluation, 
        currentArg];
    While[! closeEnough && numIter < maxNumIter, 
      If[isTracing, 
        Print["currentArg: ", currentArg, "  oldDiff: ", oldDiff, 
          "  newDiff: ", newDiff]];
      currentArg = N[(currentArg + argOfEvaluation)]/2.;
      oldDiff = newDiff;
      newDiff = 
        finiteDifference[fcnOfOneArg, fcnAtArgOfEvaluation, argOfEvaluation, 
          currentArg];
      numIter += 1;
      closeEnough = (error = Abs[oldDiff - newDiff]) <= maxErr];
    If[! closeEnough, 
      Print["WARNING: error is ", error, " for evaluation at ", 
        argOfEvaluation]];
    newDiff]
nSecondDerivative[
    fcnOfOneArg_, {argOfEvaluation_?NumberQ, initialArg_?NumberQ}, 
    opts___Rule] :=
  Module[
    {argDiff = N[Abs[argOfEvaluation - initialArg]], closeEnough = False, 
      fcnAtArgOfEvaluation = fcnOfOneArg[argOfEvaluation], numIter = 0, 
      maxNumIter = (MaxIterations /. {opts} /. Options[nSecondDerivative]), 
      maxErr = (maxError /. {opts} /. Options[nSecondDerivative]), 
      isTracing = (traceQ /. {opts} /. Options[nSecondDerivative]), newDiff, 
      oldDiff, error},
    newDiff = 
      finiteSecondDifference[fcnOfOneArg, fcnAtArgOfEvaluation, argOfEvaluation, argDiff];
    While[! closeEnough && numIter < maxNumIter, argDiff = argDiff/2.;
      oldDiff = newDiff;
      newDiff = 
        finiteSecondDifference[fcnOfOneArg, fcnAtArgOfEvaluation, argOfEvaluation, 
          argDiff];
      numIter += 1;
      If[isTracing, 
        Print["argDiff: ", argDiff, "  oldDiff: ", oldDiff, "  newDiff: ", 
          newDiff]];
      closeEnough = (error = Abs[oldDiff - newDiff]) <= maxErr];
    If[! closeEnough, 
      Print["WARNING: error is ", error, " for evaluation at z = ", 
        argDiff]];
    newDiff
    ](*based on FORTRAN function deriv() of e - mail from Rob Kass (8/30/00), 
    but with the sign corrected*)

autoInitialArg[argOfEvaluation_?NumberQ, fractionToAdd_?NumberQ] := 
  N[If[argOfEvaluation == 0, fractionToAdd, 
      argOfEvaluation*(1. + fractionToAdd)]]

autoInitialArg[argOfEvaluation_?NumberQ] :=
  Module[
    {tempReturn, fractionToAdd = N[1/10000]},
    tempReturn = autoInitialArg[argOfEvaluation, fractionToAdd];
    While[
      argOfEvaluation - tempReturn == 0 || tempReturn == argOfEvaluation,
      fractionToAdd *= 10.;
      Print["autoInitialArg[] is changing fractionToAdd to ", fractionToAdd];
      tempReturn = autoInitialArg[argOfEvaluation, fractionToAdd];
      ];
    tempReturn
    ]

nDerivative[fcnOfOneArg_, argOfEvaluation_?NumberQ, opts___Rule]:=nDerivative[fcnOfOneArg, {argOfEvaluation, autoInitialArg[argOfEvaluation]}, opts]

nSecondDerivative[fcnOfOneArg_, argOfEvaluation_?NumberQ, opts___Rule] := 
  nSecondDerivative[
    fcnOfOneArg, {argOfEvaluation, autoInitialArg[argOfEvaluation]}, opts]

sampleTime[timeSeries_?MatrixQ] :=
  Module[
    {tempReturn = timeSeries[[2, 1]] - timeSeries[[1, 1]]},
    If[tempReturn*(Length[timeSeries] - 1) != 
        Last[timeSeries][[1]] - First[timeSeries][[1]], 
      Print["UNEQUAL SPACING WARNING. \
{timeSeries[[1,1]],timeSeries[[2,1]],Last[timeSeries][[1]],Length[timeSeries],\
tempReturn}: ", {timeSeries[[1, 1]], timeSeries[[2, 1]], 
          Last[timeSeries][[1]], Length[timeSeries], tempReturn}]; 
      (*Throw[sampleTimeError]*)];
    tempReturn
    ]

firstDifference[someData_?VectorQ] := 
  Table[someData[[i + 1]] - someData[[i]], {i, Length[someData] - 1}]

firstDifference[someData_?MatrixQ]:=Table[{(someData[[i + 1,1]] + someData[[i,1]])/2,someData[[i + 1,2]] - someData[[i,2]]}, {i, Length[someData] - 1}]

mapToSubseries[fcnOfVector_, dataVsTime_?MatrixQ, timePerSubseries_?NumberQ] :=  
  Module[
    {numSubseries = 
        Floor[(dataVsTime[[-1, 1]] - dataVsTime[[1, 1]])/timePerSubseries]},
    Table[
      fcnOfVector[#[[2]] & /@ 
          Select[dataVsTime, 
            dataVsTime[[1, 1]] + (i - 1)*timePerSubseries <= #[[1]] < 
                dataVsTime[[1, 1]] + i*timePerSubseries &]],
      {i, numSubseries}
      ]
    ]

nthLowest[someData_?VectorQ, n_?IntegerQ] := Sort[someData][[n]]

nthHighest[someData_?VectorQ, n_?IntegerQ] := nthLowest[someData, -n]

linkUNIX[]:=
  Module[
    {x, y, nb},
    y=ToString[ToFileName[Extract["FileName"/.NotebookInformation[EvaluationNotebook[]],{1},FrontEnd`FileName]]];
    x=ToString[EvaluationNotebook[]];
    x=StringTake[x,{18,-4}];
    nb=StringJoin[y,x];
    nb=If[StringTake[nb,-3]\[Equal]".nb", nb, StringJoin[nb, ".nb"]];
    StringJoin["open \"", nb, "\""]
    ]

End[](*End private*)

EndPackage[]