(* THE USE OF THIS FILE IS SUBJECT TO THE LICENSE SPECIFIED IN THE FILE CALLED "COMMON.M".*)

(* 5/15/02  robustParametricMode added.*)
(*  9/6/01  'Kernal' was changed to 'kernel' throughout this package.*)
(*  9/5/01  parametricMode modified to handle case in which the minimum value of the sample is the best estimate of the mode.*)
(* 8/31/01  In intervalBasedMode, dataInNewInterval is now based on "<=" rather than on "<";
            sqrt added to correct normalKernel.*)
(* 8/23/01  error checking added to intervalBasedMode; intervalBasedMode made compatible with multiple repeated numbers, necessary for bootstrapping small samples and for heavy low-variance contamination.*)
(* 8/22/01  intervalBasedMode forced to be numeric (N).*)
(* 8/15/01  intervalBasedMode made iterative instead of recursive.*)
(* 7/26/01  maxPortionDensityError option added to pdfEstimate.*)
(* 7/25/01  implementation of pdfEstimateMode changed.*)
(* 7/25/01  modalSkewness added.*)
(* 7/24/01, 7/25/01  normalKernel changed.*)
(* 7/20/01  silvermanSmoothingParameter changed.*)
(* 7/11/01  pdfEstimate and pdfEstimateMode added.*)
(* 5/21/01  Mode estimators restored.*)
(* 3/22/01  error of 3/15/01 corrected.*)
(* 3/15/01  implementations of mode estimators changed and plans for the mode estimators under development added.*)
(*  3/8/01  intervalBasedMode fcn. corrected and made consistent with D. R. Bickel, submitted to Computational Statistics and Data Analysis.*)
(*  3/7/01  shorth and leastMedianOfSquaresLocation fcns. added.*)
(*  1/9/01  traceQ option added to shortestCI.*)
(*12/11/00  sensitivityCurvePlot[] added and subsetWithModalInterval[] made public.*)
(* 7/20/00  argOfOnlyMaximum[] corrected.*)
(* 7/ 7/00  implementation of argOfOnlyMaximum[] corrected.*)
(* 7/ 6/00  argOfOnlyMaximum[], standardizedMedianDeviation[], parametricMode[], transformData[], transformValue[], untransformedPDF[], normality[], bestTransformationExponent[], and generalizedCorrelation[] added.*)
(* 6/23/00  shortestCI[] now returns Null for error.*)
(* 6/16/00  implementation of intervalBasedMode[] changed.*)
(* 6/8/00  expectedOrderStatistics option added to idealSample[] and stylizedSensitivityCurve[]; indicesForShortestInterval[] added for intervalBasedMode[]*)
(* 6/5/00  intervalBasedMode[] added.*)
(* 6/2/00  intervalPrecision option added to rangeBasedMode[].*)
(* 5/26/00 shortestCI[] modified so that all the shortestCIs are averaged instead of returning the first one.*)
(* 5/25/00 sensitivityCurve[] and idealSample[] added.*)
(* 5/24/00 rangeBasedMode[] replaced robustMode[].*)
(* 5/19/00 optimizedEstimate[] added.*)
(* 5/12/00 dependence on "Statistics`ConfidenceIntervals`" added.*)
(*  5/9/00 shortestCI[] and shortestRange[] added.*)
(* 3- 3-00 robustMode[] added.*)
(* 2-24-00 listOfEstimates[] added.*)
(* 2- 1-00 theMode[] and grenanderMode[] added.*)
(* 9- 1-99 function(s) related to firstOrderKurtosis[] added.*)
(* 9- 1-99 dependence on "BickelPackages`Common`" added.
	momentOfPDF[], kurtosis[pdf], robustKurtosis[pdf], kurtosisExcess[pdf], and robustKurtosisExcess[pdf] 
	moved to BickelPackages`CustomDistribution` or BickelPackages`Common`.*)
(* 8-30-99 kurtosis[] added.*)
(* 8-22-99 BickelPackages`DescriptiveStatisticsSupp` created by David Bickel.*)

BeginPackage["BickelPackages`DescriptiveStatisticsSupp`",{"BickelPackages`Common`","BickelPackages`Rank`","Statistics`DescriptiveStatistics`","Statistics`ConfidenceIntervals`","Statistics`NormalDistribution`","Statistics`Common`DistributionsCommon`"}]

(*robustKurtosis::usage="robustKurtosis[someData_?VectorQ] returns the sample estimate of robust kurtosis.
	robustKurtosis[pdf] returns the robust kurtosis of a symmetric, zero-centered PDF."

robustKurtosisExcess::usage="robustKurtosisExcess[someData_?VectorQ] returns the sample estimate of excess robust kurtosis.
	robustKurtosisExcess[pdf] returns the excess robust kurtosis of a symmetric, zero-centered PDF, which is 0 for a normal distribution."
*)

(*robustKurtosisSymmetricZeroCentered::usage="robustKurtosisSymmetricZeroCentered[someData_?VectorQ] returns the sample estimate of robust kurtosis.
	robustKurtosis[pdf] returns the robust kurtosis of a symmetric, zero-centered PDF."

robustKurtosisExcessSymmetricZeroCentered::usage="robustKurtosisExcessSymmetricZeroCentered[someData_?VectorQ] returns the sample estimate of excess robust kurtosis.
	robustKurtosisExcess[pdf] returns the excess robust kurtosis of a symmetric, zero-centered PDF, which is 0 for a normal distribution."
*)

theMode::usage="theMode[someData_?VectorQ, opts___Rule] returns a robust, computationally efficient estimate of the mode of a single-modal distribution. It is a consistent estimator in that theMode of an infinite-length someData equals the mode of the distribution. Compare intervalBasedMode[]."

intervalBasedMode::usage="intervalBasedMode[someData_?VectorQ, opts___Rule] returns a robust, less computationally efficient estimate of the mode of a single-modal distribution. It is a consistent estimator in that intervalBasedMode of an infinite-length someData equals the mode of the distribution. Compare theMode[]."

grenanderMode::usage="grenanderMode[someData_?VectorQ, p_, k_?IntegerQ] returns Grenander's (1965) estimate, with parameters p and k, of the mode of a single-modal distribution."

listOfEstimates::usage="listOfEstimates[dataGenerationFcn_, numRealizations_?IntegerQ,estimators_?VectorQ] returns a list of vectors, where each vector corresponds to a different estimator (function of one argument) and is a list of estimates for the random data sets generated by dataGenerationFcn (don't forget the ampersand '&' as part of dataGenerationFcn, a function of no arguments). The same data sets are used for all estimators."

shortestCI::usage="shortestCI[someData_?VectorQ, opts___Rule] returns the smallest interval that contains the portion of data specified by the option ConfidenceLevel."

shortestRange::usage="shortestRange[someData_?VectorQ, opts___Rule] returns the length of the smallest interval that contains the portion of data specified by the option ConfidenceLevel."

optimizedEstimate::usage="optimizedEstimate[estimatorFcn_, someData_?VectorQ, opts___Rule] applies estimatorFcn[#]& to the data falling within shortestCI[someData,opts]."

idealSample::usage="idealSample[dataDistribution_?(! VectorQ[#] &),numPts_?IntegerQ,opts___Rule] returns a pseudosample of size numPts; it is the quantiles of dataDistribution."

sensitivityCurve::usage="sensitivityCurve[estimatorFcn_,someData_?VectorQ,newObservation_?NumberQ] returns the sensitivity curve with the addition of a new observation (rather than with replacement), according to p. 93 of Hampel, Ronchetti, Rousseeuw, and Stahel (Robust Statistics, 1986). sensitivityCurve[estimatorFcn_, dataDistribution_?(! VectorQ[#] &),newNumPts_?IntegerQ, newObservation_?NumberQ,opts___Rule] returns the stylized sensitivity curve of p. 94 if expectedOrderStatistics->False; this uses an artificial sample of quantiles according to the distribution and is similar to the influence function."

sensitivityCurvePlot::usage="sensitivityCurvePlot[sensitivityCurveFcn_, {minFcnArg_?NumberQ, maxFcnArg_?NumberQ},opts___Rule] plots a sensitivityCurveFcn such as (sensitivityCurve[Mean,idealData`normal1`sampleSize19,#]&)."


transformValue::usage="transformValue[transformationExponent_?NumberQ, value_?NumberQ] returns value^transformationExponent if value is positive."

transformData::usage="transformData[transformationExponent_?NumberQ, someData_?VectorQ] applies transformValue to each element of someData."


generalizedCorrelation::usage="generalizedCorrelation[someData_?(MatrixQ[#] && Length[#[[1]]] \[Equal] 2 &), opts___Rule] and generalizedCorrelation[data1_?VectorQ, data2_?VectorQ, opts___Rule] return the correlation coefficient defined as per Correlation[] of the Statistics`MultiDescriptiveStatistics` standard package."

argOfOnlyMaximum::usage="argOfOnlyMaximum[fcn_, {minArg_, maxArg_}, maxError_?NumberQ,opts___Rule] returns the maximum of the argument of fcn[argument], assuming there is only one maximum in the range minArg<=argument<=maxArg."

normality::usage="normality[someData_?VectorQ, normalExpectedOrderStatistics_?VectorQ, 
    opts___Rule] and normality[someData_?VectorQ, opts___Rule] return generalizedCorrelation[] for a normal probability plot. Use idealSample[] to generate normalExpectedOrderStatistics."

bestTransformationExponent::usage="bestTransformationExponent[someData_?VectorQ, opts___Rule] returns the exponent that maximizes the normality[] of data trasformed by transformData[]."

parametricMode::usage="parametricMode[meanOfTransformedVar_?NumberQ,varianceOfTransformedVar_?NumberQ,transformationExponent_?NumberQ], parametricMode[someData_?VectorQ, transformationExponent_?NumberQ, opts___Rule], and parametricMode[someData_?VectorQ, opts___Rule]
 returns the mode found by estimating the central value of someData transformed to data that is close to normally-distributed data."

robustParametricMode::usage="robustParametricMode[someData_?VectorQ, opts___Rule] returns what is called RPM in Bickel, D. R. (2001), 'Robust and efficient estimation of the mode of continuous data: The mode as a viable measure of central tendency,' InterStat, November 2001, http://interstat.stat.vt.edu/interstat/articles/2001/abstracts/n01001.html-ssi ."


standardizedMedianDeviation::usage="standardizedMedianDeviation[someData_?VectorQ] returns MedianDeviation[], standardized such that it is equal to the standard deviation for normal data."

shorth::usage="shorth[someData_?VectorQ, opts___Rule] returns the mean of the shortest half sample, as defined in Andrews, D. F., Bickel, P. J., Hampel, F. R., Huber, P. J., Rogers, W. H., and Tukey, J. W., Princeton University Press, Princeton, NJ, Robust Estimates of Location, 1972, p. 26."

leastMedianOfSquaresLocation::usage="leastMedianOfSquaresLocation[someData_?VectorQ, opts___Rule] returns the one-dimensional LMS location, the location that minimizes the median of squares, as defined in Rousseeuw, P. J. and Leroy, A. M., John Wiley & Sons, New York, Robust Regression and Outlier Detection, 1987, p. 164-165."

normalKernel::usage="normalKernel[t_] ~ (1/(2*Pi))*Exp[-t^2/2]; for use in kernel option of pdfEstimate."

pdfEstimate::usage="pdfEstimate[someData_?VectorQ,x_?NumberQ,smoothingParameter_?NumberQ,opts___Rule] gives an estimate of pdf(x) using the kernel method."

silvermanSmoothingParameter::usage="silvermanSmoothingParameter[someData_?VectorQ] gives the smoothing parameter for pdfEstimate recommended by Silverman (1986), eqs. (3.30) and (3.31), except with standardizedMedianDeviation instead of InterquartileRange[someData]/1.34."

pdfEstimateMode::usage="pdfEstimateMode[someData_?VectorQ,smoothingParameter_?NumberQ,opts___Rule] gives an estimate of the mode from pdfEstimate and pdfEstimateMode[someData_?VectorQ,smoothingParameterFcn_?(!NumberQ[#]&),opts___Rule] does the same, using smoothingParameterFcn[someData]."

modalSkewness::usage="modalSkewness[someData_?VectorQ, modeEstimatorFcn_] returns the modal skewness, as defined by D. R. Bickel, Computational Statistics and Data Analysis, http://www.mathpreprints.com/math/Preprint/bickel/20010705.1/2/."



portionCountsPerIteration::usage="ConfidenceLevel used in shortest ranges to compute theMode."


ConfidenceLevel::usage="Determines the confidence interval."


Options[theMode] = {portionCountsPerIteration -> 1/2}
Options[optimizedEstimate] = Options[shortestRange] = Options[shortestCI] = {ConfidenceLevel -> 1/2, traceQ -> True}
Options[rangeBasedMode] = 
    Join[{intervalPrecision->10, portionRangePerIteration -> 1/2, traceQ -> False}, 
      Options[shortestRange]]
Options[subsetWithModalInterval] = {traceQ -> False}
Options[intervalBasedMode] = {portionRangePerIteration -> 1/2, 
      numDecimalPlaces -> 10, traceQ -> False}
Options[sensitivityCurve]=Options[idealSample]={expectedOrderStatistics->True}
Options[sensitivityCurvePlot] = Options[Plot]

Options[generalizedCorrelation] = {ScaleMethod -> StandardDeviation}
Options[argOfOnlyMaximum]={traceQ->False}
Options[bestTransformationExponent] = Options[robustParametricMode] = Options[parametricMode] =Join[ {normalMeanEstimator -> Mean, normalStandardDeviationEstimator -> StandardDeviation, 
    maxExponentError -> 0.0001, exponentRangeGuess -> {-1.,2.1}},Options[argOfOnlyMaximum]]
Options[normality] = Options[generalizedCorrelation]

Options[shorth] = {traceQ -> False}
Options[leastMedianOfSquaresLocation] = {traceQ -> False}

Options[pdfEstimate]={kernel -> normalKernel, maxPortionDensityError -> 0, traceQ -> False}
Options[pdfEstimateMode]=
  Join[{useFindMinimum\[Rule]True},Options[pdfEstimate],Options[shortestCI]]


Begin["`Private`"]

robustKurtosis[someData_?VectorQ] := 
  Variance[someData]/Mean[Abs[ZeroMean[someData]]]^2

meanDeviation[someData_?VectorQ]:=Mean[Abs[someData-Median[someData]]](*as per p. 611 of Numerical Recipes*)

firstOrderKurtosis[someData_?VectorQ]:=meanDeviation[someData]/MedianDeviation[someData]



theModePrivate[someData_?VectorQ, opts___Rule] :=
  Module[
    {binSize, bestIndices, indices, minRange = Infinity, aRange, diff12, 
      diff23},
    binSize = 
      Min[Ceiling[
          Length[someData]*(portionCountsPerIteration /. {opts} /. 
                Options[theMode])], Length[someData] - 1];
    (*Print[someData];*)
    If[Length[someData] == 1, someData, 
      If[Length[someData] == 2, {Mean[someData]}, 
        If[Length[someData] == 3, diff12 = someData[[2]] - someData[[1]];
          diff23 = someData[[3]] - someData[[2]];         
          If[diff12 > diff23, theModePrivate[{someData[[2]], someData[[3]]}], 
            If[diff12 < diff23, 
              theModePrivate[{someData[[1]], 
                  someData[[2]]}], {someData[[2]]}]], indices = {1, binSize};
          
          While[indices[[2]] <= Length[someData], 
            aRange = someData[[indices[[2]]]] - someData[[indices[[1]]]];
            If[aRange < minRange, minRange = aRange;
              bestIndices = indices];
            indices += 1];
          theModePrivate[Take[someData, bestIndices]]]]]
    ]

theMode[someData_?VectorQ, opts___Rule] := 
  Module[{tempReturn = theModePrivate[Sort[someData], opts]}, 
    If[Length[tempReturn] == 1, tempReturn[[1]], Print["ERROR: ", tempReturn];
       Throw[theModeError]]]


grenanderMode[someData_?VectorQ, p_, k_?IntegerQ] :=
  Module[
    {reciprocals = 
        Table[1/(someData[[i + k]] - someData[[i]])^p, {i, 
            Length[someData] - k}]},
    If[p < 1, Print[p]; Throw[grenanderModeError1]];
    If[k < p, Print[k]; Throw[grenanderModeError2]];
    If[p == 1 || k == p, Print["WARNING: Estimator not consistent."]];
    (1/2)*
      Sum[(someData[[i + k]] + someData[[i]])*reciprocals[[i]], {i, 1, 
            Length[reciprocals]}]/
        Sum[reciprocals[[i]], {i, 1, Length[reciprocals]}]
    ](*U.Grenander's (1965) estimator (Annals of Mathematical Statistics 36, 
        131)*)


inIntervalQ[
    someValue_?NumberQ, {minInInterval_?NumberQ, maxInInterval_?NumberQ},opts___Rule] :=
Module[
{numDigits=intervalPrecision/.{opts}/.Options[rangeBasedMode]},
  SetPrecision[minInInterval,numDigits] <= SetPrecision[someValue,numDigits] <= SetPrecision[maxInInterval,numDigits]
]

largestVectorsInRange[someOrderedData_?VectorQ, someRange_?NumberQ, 
    opts___Rule] :=
  Module[
    {tempReturn = {}, maxNumPoints = 0, pointsInInterval, i},
    If[traceQ /. {opts} /. Options[rangeBasedMode], 
      Print["largestVectorsInRange[",someOrderedData,",",someRange,",opts]"]];
    Do[
      interv = {someOrderedData[[i]], someOrderedData[[i]] + someRange};
      pointsInInterval = Select[someOrderedData, inIntervalQ[#, interv, opts] &];
      If[Length[pointsInInterval] > maxNumPoints, 
        maxNumPoints = Length[pointsInInterval]; 
        tempReturn = {pointsInInterval}, 
        If[Length[pointsInInterval] == maxNumPoints, 
          tempReturn = Append[tempReturn, pointsInInterval]]],
      {i, Length[someOrderedData]}
      ];
    tempReturn
    ]

largestVectorsInShortestRange[largestVectorsInCurrentRange_?MatrixQ, 
    currentRange_?NumberQ, opts___Rule] :=
  Module[
    {vectors, 
      portionRange = 
        portionRangePerIteration /. {opts} /. Options[rangeBasedMode], 
      newRange, maxNumPts},
    If[traceQ /. {opts} /. Options[rangeBasedMode], 
Print["largestVectorsInShortestRange[",largestVectorsInCurrentRange,",",currentRange,",opts]"]];
    If[
      Length[largestVectorsInCurrentRange[[1]]] <= 3,
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[{0,largestVectorsInCurrentRange}]];
      largestVectorsInCurrentRange,
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[1]];
      newRange = portionRange*currentRange;
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[2]];
      vectors = 
        Flatten[largestVectorsInRange[#, newRange, opts] & /@ 
            largestVectorsInCurrentRange, 1];
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[3]];
      maxNumPts = Max[Length /@ vectors];
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[4]];
      largestVectorsInShortestRange[Select[vectors, Length[#] == maxNumPts &],
         newRange, opts]
      ]
    ]

rangeBasedMode[someData_?(VectorQ[#] && Length[#] <= 3 &), opts___Rule] :=
  Module[
    {sortedData = Sort[someData], dis12, dis23},
    If[traceQ /. {opts} /. Options[rangeBasedMode], 
Print["rangeBasedMode[",someData,",opts]"]];
    If[
      Length[sortedData] == 1, sortedData[[1]],
      If[Length[sortedData] == 2, Mean[sortedData],
        dis12 = sortedData[[2]] - sortedData[[1]];
        dis23 = sortedData[[3]] - sortedData[[2]];
        If[
          dis12 == dis23, sortedData[[2]],
          If[
            dis12 > dis23,
            rangeBasedMode[Drop[someData, 1], opts],
            rangeBasedMode[Drop[someData, -1], opts]]
          ]
        ]
      ]
    ]

dropRepetitions[someData_?VectorQ] :=
  Module[
    {i, sortedData = Sort[someData], tempReturn},
    tempReturn = {sortedData[[1]]};
    Do[
      If[sortedData[[i + 1]] != sortedData[[i]], 
        tempReturn = Append[tempReturn, sortedData[[i + 1]]]],
      {i, 1, Length[someData] - 1}
      ];
    tempReturn
    ]

rangeBasedMode[someData_?(VectorQ[#] && Length[#] > 3 &), opts___Rule] :=
  Module[
    {sortedData = Sort[someData], range0 = shortestRange[someData, opts], 
      dataVectors},
    If[traceQ /. {opts} /. Options[rangeBasedMode], 
Print["rangeBasedMode[",someData,",opts]"]];
    dataVectors = 
      largestVectorsInShortestRange[
        largestVectorsInRange[sortedData, range0, opts], range0, opts];
If[traceQ /. {opts} /. Options[rangeBasedMode],Print[dataVectors]];
    rangeBasedMode[dropRepetitions[rangeBasedMode[#,opts]& /@ dataVectors],opts]
    ]

indicesForShortestInterval[sortedData_?VectorQ, pointsPerInterval_?IntegerQ] :=  Module[
    {bestIndices = {}, intervalSize, shortestIntervalSize = Infinity},
    Do[
      intervalSize = 
        sortedData[[i - 1 + pointsPerInterval]] - sortedData[[i]];
      If[
        intervalSize < shortestIntervalSize,
        shortestIntervalSize = intervalSize;
        bestIndices = {i},
        If[
          intervalSize == shortestIntervalSize,
          bestIndices = Append[bestIndices, i]
          ]
        ],
      {i, Length[sortedData] + 1 - pointsPerInterval}
      ];
    bestIndices
    ]


subsetWithModalInterval[sortedData_?VectorQ, intervalSize_?NumberQ,opts___Rule] :=
  Module[
    {bestIndices = {}, subset, maxNum = 0, 
      tracingQ = traceQ /. {opts} /. Options[subsetWithModalInterval]},
    Do[
      subset = 
        Select[Drop[sortedData, 
            i - 1], # <= sortedData[[i]] + intervalSize &];
      If[
        Length[subset] > maxNum,
        maxNum = Length[subset]; bestIndices = {i},
        If[
          Length[subset] == maxNum,
          bestIndices = Append[bestIndices, i]
          ]
        ],
      {i, Length[sortedData]}
      ];
    If[Length[bestIndices] > 1 && tracingQ, 
          Print["WARNING #1: bestIndices==", bestIndices]];
    If[Length[bestIndices] > 1,bestIndices=indicesForShortestInterval[sortedData, maxNum]];
    If[Length[bestIndices] > 1 && tracingQ, 
          Print["WARNING #2: bestIndices==", bestIndices]];
    Take[sortedData, {Min[bestIndices], Max[bestIndices] + maxNum - 1}]
    ]


intervalBasedMode[someData_?VectorQ, opts___Rule] := 
  Module[{sortedData = Sort[N[someData]], 
      isTracing = traceQ /. {opts} /. Options[intervalBasedMode], 
      intervalWidth, 
      beta = portionRangePerIteration /. {opts} /. Options[intervalBasedMode],
       newInterval, dataInNewInterval, numInNewInterval, epsilon, 
      smallEpsilon = 
        10^(-(numDecimalPlaces /. {opts} /. Options[intervalBasedMode])), 
      modalIntervals, numInModalInterval, intervalWithMode, diffStart, 
      diffEnd, tempReturn = Null, oldLength}, 
    epsilon = Min[Select[firstDifference[sortedData], # > 0 &]]/2;
    If[epsilon  smallEpsilon, Print[epsilon, "<=", smallEpsilon];
      Throw[intervalBasedModeError1]];
    If[isTracing, 
      Print["{smallEpsilon,epsilon}: ", {smallEpsilon, epsilon}]];
    If[sortedData[[1]]== sortedData[[-1]]||!NumberQ[epsilon],tempReturn=sortedData[[1]]];
    While[
      ! NumberQ[tempReturn],
      If[isTracing && Length[sortedData]  21, Print[someData]];
      oldLength = Length[sortedData];
      numInModalInterval = 0;
      If[Length[sortedData] < 3, 
        If[Length[sortedData]  1, tempReturn = Mean[sortedData], 
          Print[sortedData];
          Throw[intervalBasedModeError2]], 
        intervalWidth = beta*(sortedData[[-1]] - sortedData[[1]]);
        Do[
          newInterval = {sortedData[[j]] - epsilon, 
              sortedData[[j]] + intervalWidth + epsilon};
          
          dataInNewInterval = 
            Select[sortedData, newInterval[[1]] <= # <= newInterval[[2]] &];
          
          newInterval = {dataInNewInterval[[1]] - epsilon, 
              dataInNewInterval[[-1]] + epsilon};
          numInNewInterval = Length[dataInNewInterval];
          If[numInNewInterval<=0,Print["dataInNewInterval: ",dataInNewInterval,"  {sortedData[[j]], intervalWidth}: ",{sortedData[[j]], intervalWidth},"  newInterval: ", newInterval];Throw[intervalBasedModeError3]];
          If[numInNewInterval > numInModalInterval, 
            numInModalInterval = numInNewInterval;
            modalIntervals = {newInterval}, 
            If[numInNewInterval == numInModalInterval, 
              modalIntervals = Append[modalIntervals, newInterval]]], {j, 1, 
            Length[sortedData] - 1}];
        If[isTracing, Print[modalIntervals]];
        intervalWithMode = 
          If[Length[modalIntervals] == 1, modalIntervals[[1]], 
            intervalWidth = Min[(#[[2]] - #[[1]]) & /@ modalIntervals];
            modalIntervals = 
              Select[modalIntervals, (#[[2]] - #[[1]]) < 
                    intervalWidth + epsilon &];
            {modalIntervals[[1, 1]], modalIntervals[[-1, 2]]}];
        If[isTracing, Print["intervalWithMode: ", intervalWithMode];
          Print["-----------------------------------------"]];
        sortedData = 
          Select[sortedData, 
            intervalWithMode[[1]] < # < intervalWithMode[[2]] &];
        If[Length[sortedData] == oldLength, 
          diffStart = sortedData[[2]] - sortedData[[1]];
          diffEnd = sortedData[[-1]] - sortedData[[-2]];
          
          sortedData = 
            If[Abs[diffStart - diffEnd] < smallEpsilon, 
              Take[sortedData, {2, -2}], 
              If[diffStart < diffEnd, Drop[sortedData, -1], 
                Drop[sortedData, 1]]];]]];
    tempReturn
    ]

listOfEstimates[dataGenerationFcn_, numRealizations_?IntegerQ, 
    estimators_?VectorQ] :=
  Module[
    {i, dataSets},
    dataSets = Table[dataGenerationFcn[], {i, numRealizations}];
    Table[
      (estimators[[i]]) /@ dataSets,
      {i, Length[estimators]}
      ]
    ]

(*shortestCI[someData_?VectorQ, opts___Rule] := 
  Module[{numPtsInCI, minRange = Infinity, aRange, bestIndicesList = {}, 
      indices, sortedData = Sort[someData], i}, 
    numPtsInCI = 
      Ceiling[Length[
            sortedData]*(ConfidenceLevel /. {opts} /. Options[shortestCI])];
    indices = {1, numPtsInCI};
    While[
      indices[[2]] <= Length[sortedData], 
      aRange = sortedData[[indices[[2]]]] - sortedData[[indices[[1]]]];
      If[aRange < minRange, minRange = aRange; bestIndicesList = {indices}, 
        If[aRange == minRange, 
          bestIndicesList = Append[bestIndicesList, indices]]];
      indices += 1
      ];
    shortestCIs = 
      Table[{sortedData[[bestIndicesList[[i, 1]]]], 
          sortedData[[bestIndicesList[[i, 2]]]]}, {i, 
          Length[bestIndicesList]}];
    If[Length[shortestCIs] > 2, 
      (*Print["WARNING: multiple shortestCIs: ",shortestCIs];*)Null,
      shortestCIs[[1]]
    ]
  ]*)
shortestCI[someData_?VectorQ, opts___Rule] := 
  Module[{numPtsInCI, minRange = Infinity, aRange, bestIndicesList = {}, 
      indices, sortedData = Sort[someData], i, isTracing=traceQ/.{opts}/.Options[shortestCI]}, 
    numPtsInCI = 
      Ceiling[Length[
            sortedData]*(ConfidenceLevel /. {opts} /. Options[shortestCI])];
    indices = {1, numPtsInCI};
    While[
      indices[[2]] <= Length[sortedData], 
      aRange = sortedData[[indices[[2]]]] - sortedData[[indices[[1]]]];
      If[aRange < minRange, minRange = aRange; bestIndicesList = {indices}, 
        If[aRange == minRange, 
          bestIndicesList = Append[bestIndicesList, indices]]];
      indices += 1
      ];
    shortestCIs = 
      Table[{sortedData[[bestIndicesList[[i, 1]]]], 
          sortedData[[bestIndicesList[[i, 2]]]]}, {i, 
          Length[bestIndicesList]}];
    If[Length[shortestCIs] > 2 && isTracing, 
      Print["WARNING: taking the average of these shortestCIs: ", 
        shortestCIs]];
    Mean /@ Transpose[shortestCIs]]

shortestRange[someData_?VectorQ, opts___Rule] :=
  Module[
    {sci = shortestCI[someData, opts]},
    sci[[2]] - sci[[1]]
    ]

optimizedEstimate[estimatorFcn_, someData_?VectorQ, opts___Rule] :=
  Module[
    {minInCI, maxInCI},
    {minInCI, maxInCI} = shortestCI[someData, opts];
    estimatorFcn[Select[someData, minInCI <= # <= maxInCI &]]
    ]

idealSample[dataDistribution_?(! VectorQ[#] &),numPts_?IntegerQ,opts___Rule]:=
  Module[
    {i},
   If[
    (expectedOrderStatistics/.{opts}/.Options[idealSample]),
    Table[Quantile[dataDistribution, (i-1/2)/numPts] // N, {i, numPts}],
    Table[Quantile[dataDistribution, i/(numPts+1)] // N, {i, numPts}]
   ]
  ]


sensitivityCurve[estimatorFcn_, someData_?VectorQ,newObservation_?NumberQ,opts___Rule] := (Length[someData] + 
        1)*(estimatorFcn[Append[someData, newObservation]] - 
        estimatorFcn[someData])

sensitivityCurve[estimatorFcn_, dataDistribution_?(! VectorQ[#] &),newNumPts_?IntegerQ, newObservation_?NumberQ,opts___Rule] :=
  Module[
    {i},
    sensitivityCurve[estimatorFcn, 
      idealSample[dataDistribution,newNumPts-1,opts],
       newObservation]
    ]

sensitivityCurvePlot[sensitivityCurveFcn_, {minFcnArg_?NumberQ, maxFcnArg_?NumberQ},opts___Rule] := 
  Plot[sensitivityCurveFcn[x], {x, minFcnArg, maxFcnArg}, opts, 
    PlotRange -> All, Frame -> True, Axes -> None, 
    FrameLabel -> {"x", "Sensitivity Curve", None, None}]





transformValue[transformationExponent_?NumberQ, value_?NumberQ] := 
  If[value > 0, value^transformationExponent, Throw[transformValueError]]

transformData[transformationExponent_?NumberQ, someData_?VectorQ] := 
  transformValue[transformationExponent, #] & /@ someData


generalizedCorrelation[someData_?(MatrixQ[#] && Length[#[[1]]] \[Equal] 2 &), 
    opts___Rule] := 
  generalizedCorrelation[#[[1]] & /@ someData, #[[2]] & /@ someData, opts]

generalizedCorrelation[data1_?VectorQ, data2_?VectorQ, opts___Rule] :=
  Module[
    {s = ScaleMethod /. {opts} /. Options[generalizedCorrelation], plusSS, 
      minusSS, scale1, scale2},
    scale1 = s[data1];
    scale2 = s[data2];
    plusSS = (s[data1/scale1 + data2/scale2])^2;
    minusSS = (s[data1/scale1 - data2/scale2])^2;
    (plusSS - minusSS)/(plusSS + minusSS)
    ]

argOfOnlyMaximum[fcn_, {minArg_, maxArg_}, maxError_?NumberQ, opts___Rule] := 
  Module[
    {lowArg, highArg, isBracketed = False, 
      isTracing = traceQ /. {opts} /. Options[argOfOnlyMaximum], argIntervals,
       i, intervalSize, diffs, numDiffs = 4},
    If[isTracing, Print[{minArg, maxArg}]];
    If[
      maxArg < minArg,
      Throw[argOfOnlyMaximumError1],
      If[
        maxArg - minArg <= maxError,
        Mean[{minArg, maxArg}],
        intervalSize = (maxArg - minArg)/numDiffs;
        argRanges = 
          Table[{minArg + (i - 1)*intervalSize, minArg + i*intervalSize}, {i, 
              1, numDiffs}];
        diffs = 
          Table[fcn[argRanges[[i, 2]]] - fcn[argRanges[[i, 1]]], {i, 1, 
              numDiffs}];
        If[isTracing, Print[{argRanges, diffs}]];
        i = 1;
        While[
          ! isBracketed,
          If[
              i + 1 > numDiffs,
              If[
                fcn[minArg] < fcn[maxArg],
                {lowArg, highArg} = {maxArg - intervalSize, maxArg},
                If[
                  fcn[minArg] > fcn[maxArg],
                  {lowArg, highArg} = {minArg, minArg + intervalSize},
                  Print[{{minArg, maxArg}, {fcn[minArg], fcn[maxArg]}}]; 
                  Throw[argOfOnlyMaximumError2]
                  ]
                ];
              isBracketed = True,
              If[
                diffs[[i]] >= 0 && diffs[[i + 1]] <= 0,
                lowArg = argRanges[[i, 1]]; highArg = argRanges[[i + 1, 2]]; 
                isBracketed = True
                ];
              i += 1;
              ];
          ];
        argOfOnlyMaximum[fcn, {lowArg, highArg}, maxError, opts]
        ]
      ]
    ]

normality[someData_?VectorQ, normalExpectedOrderStatistics_?VectorQ, 
    opts___Rule] :=
  generalizedCorrelation[Sort[someData], normalExpectedOrderStatistics, opts]

normality[someData_?VectorQ, opts___Rule] :=
  normality[someData, idealSample[NormalDistribution[0, 1], Length[someData]],
     opts]


bestTransformationExponent[someData_?VectorQ, opts___Rule] :=
  Module[
    {normalExpectedStats = 
        idealSample[NormalDistribution[0, 1], Length[someData], 
          expectedOrderStatistics \[Rule] True], sortedData = Sort[someData], 
      currentExponent = 1, minExponent, maxExponent, 
      transformedData, 
      sdFcn = normalStandardDeviationEstimator /. {opts} /. 
          Options[parametricMode], minR, maxR, currentR},
    {minExponent,maxExponent}=(exponentRangeGuess/.{opts}/.Options[bestTransformationExponent]);
    While[
      minR = 
        normality[transformData[minExponent, sortedData], normalExpectedStats,
           ScaleMethod \[Rule] sdFcn];
      currentR = 
        normality[transformData[currentExponent, sortedData], 
          normalExpectedStats, ScaleMethod \[Rule] sdFcn];
      minR \[GreaterEqual] currentR,
      currentExponent = minExponent;
      minExponent *= 2
      ];
    currentExponent = 1;
    While[
      maxR = 
        normality[transformData[maxExponent, sortedData], normalExpectedStats,
           ScaleMethod \[Rule] sdFcn];
      currentR = 
        normality[transformData[currentExponent, sortedData], 
          normalExpectedStats, ScaleMethod \[Rule] sdFcn];
      maxR \[GreaterEqual] currentR,
      currentExponent = maxExponent;
      maxExponent *= 2
      ];
    argOfOnlyMaximum[
      normality[transformData[#, sortedData], normalExpectedStats, 
          ScaleMethod \[Rule] sdFcn] &, {minExponent, maxExponent}, 
      maxExponentError /. {opts} /. Options[bestTransformationExponent],opts]
    (*return currentExponent that maximizes generalizedCorrelation[
          normalExpectedStats, normalExpectedStats, 
          ScaleMethod \[Rule] sdFcn]*)
    ]



parametricMode[meanOfTransformedVar_?NumberQ, 
    varianceOfTransformedVar_?NumberQ, transformationExponent_?NumberQ] :=
  Module[
    {tempReturn = ((meanOfTransformedVar + 
                  Sqrt[meanOfTransformedVar^2 + 
                      4*varianceOfTransformedVar*(transformationExponent - 1)/
                          transformationExponent])/2)^(1/
              transformationExponent)},
    If[Re[tempReturn] \[NotEqual] tempReturn, 
      Print["WARNING: the mode is not a real number. {meanOfTransformedVar,varianceOfTransformedVar,transformationExponent}: ",{meanOfTransformedVar,varianceOfTransformedVar,transformationExponent}]];
    tempReturn
    ]

parametricMode[someData_?VectorQ, transformationExponent_?NumberQ, 
    opts___Rule] :=
  Module[
    {meanFcn = normalMeanEstimator /. {opts} /. Options[parametricMode], 
      sdFcn = normalStandardDeviationEstimator /. {opts} /. 
          Options[parametricMode], transformedData, m, v, normalExpectedStats = 
        idealSample[NormalDistribution[0, 1], Length[someData], 
          expectedOrderStatistics \[Rule] True]},
    If[Min[someData] \[LessEqual] 0, Print[Min[someData]]; 
      Throw[parametricModeError]];
    transformedData = 
      transformData[transformationExponent, 
        someData](*transformValue[transformationExponent, #] & /@ someData*);
    m=meanFcn[transformedData];
    v=sdFcn[transformedData]^2;
    If[
      m^2+4*v*(transformationExponent-1)/transformationExponent\[LessEqual]0,
      If[
        transformationExponent>0,
        Min[someData],
        Print[
          "____________________WARNING*******WARNING_____________________"];
        ListPlot[Transpose[{normalExpectedStats,someData//Sort}],
          PlotRange\[Rule]All];
        ListPlot[Transpose[{normalExpectedStats,transformedData//Sort}],
          PlotRange\[Rule]All];
        parametricMode[m,v,transformationExponent]
        ],
      parametricMode[m,v,transformationExponent]
      ]
    ]

parametricMode[someData_?VectorQ, opts___Rule] :=
  Module[
    {},
    parametricMode[someData, bestTransformationExponent[someData, opts], 
      opts]
    ]

factorForMedianDeviation = N[1/Quantile[NormalDistribution[0, 1], 3/4]]

standardizedMedianDeviation[someData_?VectorQ] := 
  factorForMedianDeviation*MedianDeviation[someData]

robustParametricMode[someData_?VectorQ, opts___Rule] := parametricMode[someData, normalMeanEstimator -> Median, normalStandardDeviationEstimator -> standardizedMedianDeviation, opts]

shorth[someData_?VectorQ, opts___Rule] :=
  Module[
    {ptsPerMean = Floor[Length[someData]/2] + 1, startingIndex, 
      putativeIndices, isTracing = traceQ /. {opts} /. Options[shorth], 
      sortedData = Sort[someData]},
    putativeIndices = indicesForShortestInterval[sortedData, ptsPerMean];
    If[isTracing && Length[putativeIndices] > 1, 
      Print[{Take[sortedData, Min[Length[sortedData], 21]], putativeIndices, 
          ptsPerMean}]];
    If[
      OddQ[Length[putativeIndices]],
      startingIndex = putativeIndices[[(Length[putativeIndices] + 1)/2]],
      startingIndex = putativeIndices[[Length[putativeIndices]/2]];
      If[
        startingIndex + 1 == 
          putativeIndices[[Length[putativeIndices]/2 + 1]],
        startingIndex += 1;
        ptsPerMean -= 1,
        Print["Unable to find starting index from ", putativeIndices];
        Throw[shorthError]
        ]
      ];
    Mean[Take[sortedData, {startingIndex, startingIndex + ptsPerMean - 1}]]
    ]

leastMedianOfSquaresLocation[someData_?VectorQ, opts___Rule] :=
  Module[
    {ptsPerInterval = Floor[Length[someData]/2] + 1, putativeIndices, 
      isTracing = traceQ /. {opts} /. Options[shorth], 
      sortedData = Sort[someData]},
    putativeIndices = indicesForShortestInterval[sortedData, ptsPerInterval];
    If[isTracing && Length[putativeIndices] > 1, 
      Print[{Take[sortedData, Min[Length[sortedData], 21]], putativeIndices, 
          ptsPerInterval}]];
    midpoints = ((sortedData[[#]] + sortedData[[# + ptsPerInterval - 1]])/
              2) & /@ putativeIndices;
    Mean[midpoints]
    ]

normalKernal[t_]:=Module[{},Print["WARNING: SPELLING ERROR, CORRECT SPELLING IS 'normalKernel'"];normalKernel[t]]

normalKernel[t_] :=
  Module[
      {tEffectiveSquared = If[t==0, 0, If[(*Chop[1/t^2] == 0*)1/t^2<10^(-6), Infinity, t^2]]},
     Chop[(1/Sqrt[2*Pi])*Exp[-tEffectiveSquared/2]]
    ]

pdfEstimate[someData_?VectorQ, x_?NumberQ, smoothingParameter_?NumberQ, 
    opts___Rule] := Module[
    {kFcn = kernel /. {opts} /. Options[pdfEstimate], 
      maxErrP = maxPortionDensityError /. {opts} /. Options[pdfEstimate], 
      subtotal, leftErr = Infinity, rightErr = Infinity, leftIndex, 
      rightIndex, sortedData, 
      isTracing = traceQ /. {opts} /. Options[pdfEstimate]},
    If[
      maxErrP == 0,
      Sum[
          kFcn[(x - someData[[i]])/smoothingParameter], {i, 
            Length[someData]}]/(Length[someData]*smoothingParameter),
      sortedData = Sort[someData];
      leftIndex = rightIndex = indexOfMinElement[Abs[x - sortedData]];
      subtotal = kFcn[(x - sortedData[[leftIndex]])/smoothingParameter];
      While[
        subtotal > 
    0 && ((leftIndex > 1 && 
          leftErr*(leftIndex - 1)/subtotal > maxErrP) || (rightIndex < 
            Length[sortedData] && 
          rightErr*(Length[sortedData] - rightIndex)/subtotal > maxErrP)),
        If[
          (leftErr > rightErr || rightIndex == Length[sortedData]) && 
            leftIndex > 1,
          leftIndex -= 1;
          leftErr = kFcn[(x - sortedData[[leftIndex]])/smoothingParameter];
          subtotal += leftErr,
          If[
            rightIndex == Length[sortedData],
            Throw[pdfEstimateError],
            rightIndex += 1;
            
            rightErr = 
              kFcn[(x - sortedData[[rightIndex]])/smoothingParameter];
            subtotal += rightErr
            ]
          ];
        If[isTracing, Print[{{leftErr, rightErr}, subtotal}]]
        ];
      subtotal/(Length[sortedData]*smoothingParameter)
      ]
    ]

silvermanSmoothingParameter[someData_?VectorQ]:=(9/(10*Length[someData]^(1/5)))*Min[StandardDeviation[someData], standardizedMedianDeviation[someData]]

pdfEstimateMode[optsFindMinimum___Rule, someData_?VectorQ, 
    smoothingParameter_?NumberQ, opts___Rule] :=
  Module[
    {sortedData, pdf = pdfEstimate[someData, #, smoothingParameter, opts] &, 
      pdfValues, indexNearMode, x1, x2, opts2, tempReturn},
    If[
      useFindMinimum /. {opts} /. Options[pdfEstimateMode],
      {x1, x2} = shortestCI[someData, opts];
      tempReturn = 
        If[x1 == x2, x1, 
          x /. (FindMinimum[-pdf[x], {x, {x1, x2}}, optsFindMinimum][[2]])];
      If[! NumberQ[tempReturn], 
        Print["WARNING: LMS-like estimate returned as mode, mean of ", {x1, 
            x2}]; tempReturn = Mean[{x1, x2}]],
      sortedData = Sort[someData];
      pdfValues = Table[pdf[sortedData[[i]]], {i, Length[sortedData]}];
      If[traceQ /. {opts} /. Options[pdfEstimateMode], 
        ListPlot[Transpose[{sortedData, pdfValues}]]];
      indexNearMode = indexOfMaxElement[pdfValues];
      tempReturn = sortedData[[indexNearMode]]];
    tempReturn]

pdfEstimateMode[optsFindMinimum___Rule,someData_?VectorQ,
    smoothingParameterFcn_?(!NumberQ[#]&),opts___Rule]:=
  pdfEstimateMode[optsFindMinimum,someData,N[smoothingParameterFcn[someData]],
    opts]

modalSkewness[someData_?VectorQ, modeEstimatorFcn_] :=
  Module[
    {modeEstimate = modeEstimatorFcn[someData]},
    1 - 2*(Length[Select[someData, # < modeEstimate &]] + 
              Length[Select[someData, # == modeEstimate &]]/2)/
          Length[someData]
    ]


End[](*End private*)

EndPackage[]
