(* THE USE OF THIS FILE IS SUBJECT TO THE LICENSE SPECIFIED IN THE FILE CALLED "COMMON.M".*)

(* 10/5/02 saveForExcelPath added.*)
(* 2/12/02 Path of saveForExcel made compatible with native OS X.*)
(* 8/10/01 saveForExcel modified so that it doesn't write blank strings.*)
(* 7/20/01 Path of saveForExcel made compatible with OS X Classic.*)
(* 5/28/01 Path of saveForExcel made compatible with MCG Macintosh.*)
(* 3/15/01 dependence on "BickelPackages`Common`" added.*)
(* 8-20-99 name changed to "BickelPackages`...`"*)
(*2-24-99 saveForExcel[] no longer requires matrix*)
(*3-12-98 added CForm[] to saveForExcel[]*)
(*3-9-98 saveForExcel[] can now handle lists of numbers as well as matrices.*)
(*2-13-98 new functions (mapReplaceAll[] and saveForExcel[]) were added--these functions are tested in "Hypothesis DA of preterm heart increments 12.nb"*)

BeginPackage["BickelPackages`MultipleDataSets`",{"BickelPackages`Common`"}]

readMultipleLists::usage="readMultipleLists[someDirectory,fileNameList] returns an array of lists representing the files specified."
mapAdvanced::usage="mapAdvanced[mappingFunction,listOfFirstArgs,listOfOtherArgs] maps mappingFunction (with arguments after the first given by listOfOtherArgs) to listOfFirstArgs. This is equivalent to mapAdvancedGeneral[mappingFunction,{listOfFirstArgs},listOfOtherArgs]."
mapAdvancedGeneral::usage="mapAdvancedGeneral[mappingFunction,{listOfFirstArgs,listOfSecondArgs,...,listOfNthArgs},listOfOtherArgs] maps mappingFunction (with arguments after the first N given by listOfOtherArguments) to listOfFirstArgs,listOfSecondArgs,...,listOfNthArgs. This is a generalization of mapAdvanced."
plotMultipleDataSets::usage="plotMultipleDataSets[plottingFunction,listOfDataSetsToPlot,listOfLabels,listOfOptions] uses plottingFunction to plot each element of listOfDataSetsToPlot using the labels listOfLabels and the options listOfOptions."
mapReplaceAll::usage="mapReplaceAll[leftHandSideOfRule,listOfRuleLists] returns a list of values of listOfRuleLists that correspond to leftHandSideOfRule."
saveForExcel::usage="saveForExcel[originalData,rowLabels,columnLabels,nameOfTable,nameOfFile] saves originalData to the file nameOfFile.xls in the directory saveForExcelPath in a text tab-delimited table form for use by Microsoft Excel. If originalData is a list of numbers rather than a matrix, then the arguments rowLabels and columnLabels must be omitted; they may optionally be ommited for matrices."

saveForExcelPath = "/Users/bickel/Temp"


Begin["`Private`"]

readMultipleLists[someDirectory_,fileNameList_]:=
	Module[
		{tempReturn={}},
		Do[
			tempReturn=Append[tempReturn,ReadList[someDirectory<>"\\"<>fileNameList[[i]],Number]],
			{i,1,Length[fileNameList]}
		];
		tempReturn
	]

mapAdvanced[mappingFunction_,listOfFirstArgs_,listOfOtherArgs_]:=
	Table[Apply[mappingFunction[listOfFirstArgs[[i]],##] &,listOfOtherArgs],{i,1,
      Length[listOfFirstArgs]}]

mapAdvancedGeneral[mappingFunction_,
    arrayOfListsOfBeginningArgs_(*{listOfFirstArgs_,listOfSecondArgs_,...}*),
    listOfOtherArgs_]:=
	Module[
		{listOfBeginningArgs=
        Transpose[arrayOfListsOfBeginningArgs](*{beginningArgsOfListElement1,
          beginningArgsOfListElement2,...}*),
      lengthOfEachListOfBeginningArgs=
        Length[First[arrayOfListsOfBeginningArgs]]},
		Do[
			If[Length[arrayOfListsOfBeginningArgs[[i]]]!=
          lengthOfEachListOfBeginningArgs,Throw[error1]],
			{i,2,Length[arrayOfListsOfBeginningArgs]}
		];
		Table[Apply[mappingFunction[##] &,
        Join[listOfBeginningArgs[[i]],listOfOtherArgs]],{i,1,
        lengthOfEachListOfBeginningArgs}]
	]

plotMultipleDataSets[plottingFunction_,listOfDataSetsToPlot_,listOfLabels_,
    listOfOtherArgs_]:=
	Table[Apply[
      plottingFunction[listOfDataSetsToPlot[[i]],
          PlotLabel->ToString[i]<>": "<>listOfLabels[[i]],##] &,
      listOfOtherArgs],{i,1,Length[listOfDataSetsToPlot]}]

mapReplaceAll[leftHandSideOfRule_?AtomQ,listOfRuleLists_?ListQ]:=
  Table[leftHandSideOfRule/.listOfRuleLists[[i]],{i,Length[listOfRuleLists]}]

sequenceFromList[someList_?ListQ]:=Apply[Sequence,someList]

saveForExcel[originalData_?ListQ, rowLabels_?ListQ, columnLabels_?ListQ, 
    nameOfTable_?StringQ, nameOfFile_?StringQ] := 
  Module[{someData = 
          If[AtomQ[First[originalData]], 
            Table[{i, originalData[[i]]}, {i, Length[originalData]}], 
            originalData],
        pathAndFileName, excelStream},
      pathAndFileName = 
          saveForExcelPath<>"/" <> nameOfFile <> ".xls";
      If[!StringQ[pathAndFileName], Print[pathAndFileName]; Throw[saveForExcelError]];
      excelStream = OpenWrite[pathAndFileName];
      If[nameOfTable != "", 
        WriteString[excelStream, TextForm[nameOfTable <> "\t"], 
          sequenceFromList[
            Table[TextForm[
                columnLabels[[i]] <> 
                  If[columnLabels[[1]] == "", "", "\t"]], {i, 
                Length[columnLabels]}]], "\n"]];
      Do[WriteString[excelStream, 
          TextForm[rowLabels[[i]] <> If[rowLabels[[1]] == "", "", "\t"]]];
        WriteString[excelStream, 
          sequenceFromList[
            Table[TextForm[ToString[CForm[someData[[i, j]]]] <> "\t"], {j, 
                Length[someData[[i]]]}]], "\n"], {i, Length[someData]}];
      Close[excelStream]] /; Length[originalData] == Length[rowLabels]

      
saveForExcel[originalData_?ListQ,
    nameOfList_?StringQ,nameOfFile_?StringQ]:=
	saveForExcel[originalData,
    Table["",{i,Length[originalData]}],
    Table["",{i,Length[First[originalData]]}],nameOfList,nameOfFile]

saveForExcel[originalData_?ListQ/;(NumberQ[First[originalData]]),
    nameOfList_?StringQ,nameOfFile_?StringQ]:=
	saveForExcel[Map[List,originalData],
    Table[ToString[i],{i,Length[originalData]}],{""},nameOfList,nameOfFile]

End[](*End private*)

EndPackage[]
