(* THE USE OF THIS FILE IS SUBJECT TO THE LICENSE SPECIFIED IN THE FILE CALLED "COMMON.M".*)

(* 8/ 1/01 implementation of rankData modified for speed.*)
(* 7/31/01 randomRanks and randomPermutation added; sortByRank modified.*)
(* 3/15/01 licenseAgreement and technicalSupport moved to "BickelPackages`Common`".*)
(* 6/29/00 licenseAgreement and technicalSupport added.*)
(* 4/ 1/00 rankData[] modified*)
(* 3/17/00 sortByRank[] added*)
(* 8-20-99 name changed to "BickelPackages`...`"*)
(*5-26-98 indexOfMaxElement[] added*)

BeginPackage["BickelPackages`Rank`"]

indexOfMinElement::usage="indexOfMinElement[someData] returns the index of Min[someData]."

rankData::usage="rankData[someData] returns a list of ranks corresponding to the elements of someData."

sortByRank::usage="sortByRank[someData_?VectorQ, someRanks_?VectorQ] sorts someData according to someRanks."

indexOfMaxElement::usage="indexOfMaxElement[someData] returns the index of Max[someData]."

indexOfExtremeElement::usage="indexOfExtremeElement[someData] returns the index of Max[Abs[someData]]."

randomRanks::usage="randomRanks[numRanks_?IntegerQ] returns a list of numRanks integers chosen randomly from 1 to numRanks without replacement, i.e., a random permutation of ranks."

randomPermutation::usage="randomPermutation[someData_?ListQ] returns Length[someData] numbers randomly selected from someData without replacement."

Options[rankData]={nonNumericValue->-Infinity}




Begin["`Private`"]

indexOfExtremeElement[someData_?VectorQ]:=indexOfMaxElement[Abs[someData]]

indexOfMinElement[someData_?ListQ]:=
	Module[
		{tempReturn=1},	
		Do[
			If[someData[[i]]<someData[[tempReturn]],tempReturn=i],
			{i,1,Length[someData]}
		];
		tempReturn
	]

indexOfMaxElement[someData_?ListQ]:=indexOfMinElement[-someData]
rankDataPrivate[someData_?VectorQ]:=
  Module[
    {orderedRanks=Table[i,{i,Length[someData]}],indices,t},
    indices=#[[2]]&/@
        Sort[Transpose[{someData,orderedRanks}],#1[[1]]<#2[[1]]&];
    #[[2]]&/@Sort[Transpose[{indices,orderedRanks}],#1[[1]]<#2[[1]]&]
    ]

rankDataPrivate[someData_?VectorQ, valueOfNonNumeric_] := 
  rankDataPrivate[If[NumberQ[#], #, valueOfNonNumeric] & /@ someData]

rankData[someData_?VectorQ, opts___Rule] :=
  rankDataPrivate[someData, nonNumericValue /. {opts} /. Options[rankData]]

sortByRank[someData_?ListQ, someRanks_?VectorQ] :=
  (#[[1]]&/@Sort[Transpose[{someData,someRanks}],#1[[2]]<#2[[2]]&])/; (Length[someData] == Length[someRanks])

randomRanks[numRanks_?IntegerQ]:=
  Module[
    {ranks=Table[i,{i,numRanks}],randomIndex,tempReturn={}},
    Table[
     randomIndex=Random[Integer,{1,Length[ranks]}];
     tempReturn=Append[tempReturn,ranks[[randomIndex]]];
     ranks=Drop[ranks,{randomIndex}],
     {i,numRanks}
    ];
    tempReturn
  ]

randomPermutation[someData_?ListQ]:=sortByRank[someData,randomRanks[Length[someData]]]

End[](*End private*)

EndPackage[] 