/*
 * Decompiled with CFR 0.152.
 */
package Plato;

import Plato.Matrix;
import Plato.MomentStats;

public class AssociationMatrix
extends Matrix {
    MomentStats msLocal = new MomentStats();
    int numVectors = 0;

    public void clearMatrix() {
        super.clearMatrix();
        this.numVectors = 0;
    }

    public void printMatrix() {
        int limit = 10;
        System.out.println("numVectors: " + this.numVectors);
        if (this.numVectors <= limit) {
            int i = 0;
            while (i < this.numVectors) {
                int j = 0;
                while (j < this.numVectors) {
                    System.out.print(String.valueOf(this.getElement(i, j)) + "\t");
                    ++j;
                }
                System.out.println("");
                ++i;
            }
        }
        System.out.println();
    }

    public float getElement(int vectorIndex1, int vectorIndex2) {
        if (vectorIndex2 <= vectorIndex1) {
            return super.getElement(vectorIndex1, vectorIndex2);
        }
        return super.getElement(vectorIndex2, vectorIndex1);
    }

    AssociationMatrix(Matrix vectorsToAssociate) throws Throwable {
        int numRows;
        this.numVectors = numRows = vectorsToAssociate.getNumRows();
        float[][] assocMatrixValues = new float[this.numVectors][];
        int rowNum = 0;
        while (rowNum < this.numVectors) {
            assocMatrixValues[rowNum] = new float[rowNum + 1];
            int colNum = 0;
            while (colNum <= rowNum) {
                assocMatrixValues[rowNum][colNum] = this.msLocal.linearCorrelationCoefficient(vectorsToAssociate.getRow(rowNum), vectorsToAssociate.getRow(colNum));
                ++colNum;
            }
            ++rowNum;
        }
        this.replaceMatrix(assocMatrixValues, this.numVectors, "Association Matrix");
    }
}

