/*
 * Decompiled with CFR 0.152.
 */
package Plato;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Matrix {
    private String matrixName;
    private float[][] matrixValues;
    private int numRows;
    private int numColumns = 0;

    public void clearMatrix() {
        this.numRows = 0;
        this.numColumns = 0;
        this.matrixValues = null;
    }

    public void printMatrix() {
        int limit = 10;
        System.out.println(String.valueOf(this.matrixName) + "(" + this.numRows + " rows and " + this.numColumns + " columns):");
        int numRowsToPrint = this.numRows <= limit ? this.numRows : limit;
        int numColumnsToPrint = this.numColumns <= limit ? this.numColumns : limit;
        int i = 0;
        while (i < numRowsToPrint) {
            int j = 0;
            while (j < numColumnsToPrint) {
                System.out.print(String.valueOf(this.getElement(i, j)) + "\t");
                ++j;
            }
            System.out.println("");
            ++i;
        }
        System.out.println();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public float[] getRow(int rowNumber) {
        return this.matrixValues[rowNumber];
    }

    public float getElement(int rowNumber, int columnNumber) {
        return this.matrixValues[rowNumber][columnNumber];
    }

    public String getMatrixName() {
        return this.matrixName;
    }

    private float[] rowOfNumbers(String originalRow) throws Throwable {
        int numFloats = 0;
        int i = 0;
        Float floatObject = new Float(0.0);
        StringTokenizer st = new StringTokenizer(originalRow);
        while (st.hasMoreTokens()) {
            ++numFloats;
            st.nextToken();
        }
        float[] floatData = new float[numFloats];
        if (this.numColumns == 0) {
            this.numColumns = floatData.length;
        }
        if (this.numColumns != floatData.length) {
            throw new Exception("numColumns:" + this.numColumns + ", but this row has length of " + floatData.length);
        }
        st = new StringTokenizer(originalRow);
        while (st.hasMoreTokens()) {
            floatData[i] = Float.valueOf(st.nextToken()).floatValue();
            ++i;
        }
        return floatData;
    }

    private void readMatrix() throws Throwable {
        BufferedReader in = new BufferedReader(new FileReader(this.matrixName));
        String lineString = new String();
        int i = 0;
        System.out.println("Reading " + this.matrixName);
        while ((lineString = in.readLine()) != null) {
            if (++i > 0) continue;
            System.out.println("Row counted: " + lineString);
        }
        this.numRows = i;
        System.out.println(String.valueOf(this.numRows) + " rows");
        this.matrixValues = new float[this.numRows][];
        i = 0;
        in = new BufferedReader(new FileReader(this.matrixName));
        while ((lineString = in.readLine()) != null) {
            if (i <= 5) {
                System.out.println("Row read: " + lineString);
            }
            this.matrixValues[i] = this.rowOfNumbers(lineString);
            ++i;
        }
        in.close();
    }

    protected void replaceMatrix(float[][] newMatrixValues, int newNumColumns, String newMatrixName) throws Throwable {
        this.matrixName = newMatrixName;
        this.matrixValues = newMatrixValues;
        this.numRows = this.matrixValues.length;
        this.numColumns = newNumColumns;
        int i = 0;
        while (i < this.numRows) {
            int numValuesInRow = this.matrixValues[i].length;
            if (numValuesInRow > this.numColumns) {
                throw new Exception(String.valueOf(this.numColumns) + " is not enough columns for " + this.matrixName + ", row " + i + " of which has " + numValuesInRow + " elements.");
            }
            ++i;
        }
        System.out.println("Matrix initialized from RAM.");
    }

    public Matrix() {
        this.matrixName = "Matrix to be determined by subclass";
        this.matrixValues = null;
        this.numRows = 0;
        this.numColumns = 0;
    }

    public Matrix(String matrixFileName) throws Throwable {
        this.matrixName = matrixFileName;
        this.readMatrix();
        System.out.println("Matrix initialized from file");
    }
}

