/*
 * Decompiled with CFR 0.152.
 */
package Plato;

import Plato.AssociationMatrix;
import Plato.Matrix;
import Plato.MomentStats;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public class PlatoApplication {
    boolean isUsingAssociationMatrix;
    MomentStats msPlato = new MomentStats();
    int maxNumClusters;
    float alpha;
    boolean isUsingAbsR;
    int maxNumRelocationIterations;
    ClusteredVectors cVectors;

    public PlatoApplication() throws Throwable {
        System.out.println("\nStandard output from Plato, Version 1.11.\n");
        String inputFileName = "VectorRows.txt";
        String paramFileName = "Parameters.txt";
        Matrix vectorsToCluster = new Matrix(inputFileName);
        vectorsToCluster.printMatrix();
        Matrix paramMatrix = new Matrix(paramFileName);
        this.isUsingAssociationMatrix = false;
        this.maxNumClusters = paramMatrix.getNumRows() >= 1 ? (int)paramMatrix.getElement(0, 0) : 2;
        this.alpha = paramMatrix.getNumRows() >= 2 ? paramMatrix.getElement(1, 0) : 2.0f;
        this.isUsingAbsR = paramMatrix.getNumRows() >= 3 ? (double)paramMatrix.getElement(2, 0) >= 0.0 : false;
        if (this.maxNumClusters >= vectorsToCluster.getNumRows()) {
            throw new Exception("maxNumClusters >= # vectors to cluster");
        }
        this.maxNumRelocationIterations = 1;
        System.out.println(String.valueOf(vectorsToCluster.getMatrixName()) + " has " + vectorsToCluster.getNumRows() + " vectors of dimension " + vectorsToCluster.getNumColumns() + ".");
        System.out.println("maxNumClusters==" + this.maxNumClusters + "; stretching exponent alpha==" + this.alpha + "; is using |correlation|==" + this.isUsingAbsR);
        this.cVectors = new ClusteredVectors(vectorsToCluster);
        this.cVectors.saveClusteredVectors(inputFileName);
    }

    public static void main(String[] args) throws Throwable {
        new PlatoApplication();
    }

    class ClusteredVector {
        float[] components;
        int dimension;
        int[] clusterNumbers;
        boolean[] isCentrotypes;
        float[] centrotypeAssociations;

        public void printClusteredVector(int maxNumComponentsToPrint) {
            System.out.println("Dimension: " + this.dimension);
            int k = 1;
            while (k <= PlatoApplication.this.maxNumClusters) {
                System.out.println("In cluster #" + this.getClusterNumber(k) + " of " + k + ": " + this.getIsCentrotype(k) + " centrotype r=" + this.getMeanCentrotypeAssociation(k));
                ++k;
            }
            int i = 0;
            while (i < this.dimension && i <= maxNumComponentsToPrint) {
                System.out.print(String.valueOf(this.getComponent(i)) + "\t");
                ++i;
            }
            System.out.println();
            System.out.println();
        }

        public float getComponent(int componentIndex) {
            return this.components[componentIndex];
        }

        public float[] getComponents() {
            return this.components;
        }

        public int getDimension() {
            return this.dimension;
        }

        public int getClusterNumber(int numClusters) {
            return this.clusterNumbers[numClusters - 1];
        }

        public boolean getIsCentrotype(int numClusters) {
            return this.isCentrotypes[numClusters - 1];
        }

        public float getMeanCentrotypeAssociation(int numClusters) {
            return this.centrotypeAssociations[numClusters - 1];
        }

        public void setClusterNumber(int numClusters, int clusterNumber) {
            this.clusterNumbers[numClusters - 1] = clusterNumber;
        }

        public void setIsCentrotype(int numClusters, boolean isCentrotype) {
            this.isCentrotypes[numClusters - 1] = isCentrotype;
        }

        public void setCentrotypeAssociation(int numClusters, float centrotypeAssociation) {
            this.centrotypeAssociations[numClusters - 1] = centrotypeAssociation;
        }

        ClusteredVector(float[] vectorComponents) {
            this.components = vectorComponents;
            this.dimension = this.components.length;
            this.clusterNumbers = new int[PlatoApplication.this.maxNumClusters];
            this.isCentrotypes = new boolean[PlatoApplication.this.maxNumClusters];
            this.centrotypeAssociations = new float[PlatoApplication.this.maxNumClusters];
            int i = 0;
            while (i < PlatoApplication.this.maxNumClusters) {
                this.clusterNumbers[i] = -1;
                this.isCentrotypes[i] = false;
                this.centrotypeAssociations[i] = 0.0f;
                ++i;
            }
        }
    }

    class ClusteredVectors {
        ClusteredVector[] clusteredVectorArray;
        int numClusteredVectors;
        AssociationMatrix assocMatrix;
        float[] meanCentrotypeAssociations;

        String appendToFileName(String fileName, String whatToAppend) {
            String baseName = fileName.substring(0, fileName.length() - 4);
            String extension = fileName.substring(fileName.length() - 4, fileName.length());
            String newName = baseName.concat(whatToAppend);
            return newName.concat(extension);
        }

        public void saveClusteredVectors(String baseFileName) throws Throwable {
            String clusterNumberFileName = this.appendToFileName(baseFileName, "-typeNo");
            String isCentrotypeFileName = this.appendToFileName(baseFileName, "-isType");
            String centrotypeAssociationFileName = this.appendToFileName(baseFileName, "-typeR");
            String centrotypeDistanceFileName = this.appendToFileName(baseFileName, "-typeD");
            PrintWriter clusterNumberOut = new PrintWriter(new BufferedWriter(new FileWriter(clusterNumberFileName)));
            PrintWriter isCentrotypeOut = new PrintWriter(new BufferedWriter(new FileWriter(isCentrotypeFileName)));
            PrintWriter centrotypeAssociationOut = new PrintWriter(new BufferedWriter(new FileWriter(centrotypeAssociationFileName)));
            PrintWriter centrotypeDistanceOut = new PrintWriter(new BufferedWriter(new FileWriter(centrotypeDistanceFileName)));
            System.out.println("Writing to " + clusterNumberFileName + ", " + isCentrotypeFileName + ", " + centrotypeDistanceFileName + ", and " + centrotypeAssociationFileName);
            int i = 0;
            while (i < this.numClusteredVectors) {
                int k = 1;
                while (k <= PlatoApplication.this.maxNumClusters) {
                    clusterNumberOut.print(String.valueOf(this.getClusterNumber(i, k) + 1) + "\t");
                    isCentrotypeOut.print(String.valueOf(this.getIsCentrotype(i, k)) + "\t");
                    centrotypeAssociationOut.print(String.valueOf(this.getMeanCentrotypeAssociation(i, k)) + "\t");
                    centrotypeDistanceOut.print(String.valueOf(-this.getMeanCentrotypeAssociation(i, k)) + "\t");
                    ++k;
                }
                clusterNumberOut.println();
                isCentrotypeOut.println();
                centrotypeAssociationOut.println();
                centrotypeDistanceOut.println();
                ++i;
            }
            clusterNumberOut.close();
            isCentrotypeOut.close();
            centrotypeAssociationOut.close();
            centrotypeDistanceOut.close();
        }

        public float getMeanCentrotypeAssociation(int numClusters) {
            return this.meanCentrotypeAssociations[numClusters - 1];
        }

        public void printClusteredVectors(int maxNumToPrint) {
            System.out.println();
            int i = 0;
            while (i < Math.min(maxNumToPrint, this.numClusteredVectors)) {
                System.out.println("Clustered vector number " + i + ":");
                this.clusteredVectorArray[i].printClusteredVector(maxNumToPrint);
                ++i;
            }
            System.out.println();
        }

        public float getComponent(int vectorIndex, int componentIndex) {
            return this.clusteredVectorArray[vectorIndex].getComponent(componentIndex);
        }

        public int getDimension(int vectorIndex) {
            return this.clusteredVectorArray[vectorIndex].getDimension();
        }

        public int getClusterNumber(int vectorIndex, int numClusters) {
            return this.clusteredVectorArray[vectorIndex].getClusterNumber(numClusters);
        }

        public boolean getIsCentrotype(int vectorIndex, int numClusters) {
            return this.clusteredVectorArray[vectorIndex].getIsCentrotype(numClusters);
        }

        public float getMeanCentrotypeAssociation(int vectorIndex, int numClusters) {
            return this.clusteredVectorArray[vectorIndex].getMeanCentrotypeAssociation(numClusters);
        }

        public void setClusterNumber(int vectorIndex, int numClusters, int clusterNumber) {
            this.clusteredVectorArray[vectorIndex].setClusterNumber(numClusters, clusterNumber);
        }

        public void setIsCentrotype(int vectorIndex, int numClusters, boolean isCentrotype) {
            this.clusteredVectorArray[vectorIndex].setIsCentrotype(numClusters, isCentrotype);
        }

        public void setCentrotypeAssociation(int vectorIndex, int numClusters, float centrotypeAssociation) {
            this.clusteredVectorArray[vectorIndex].setCentrotypeAssociation(numClusters, centrotypeAssociation);
        }

        float association(int vectorIndex1, int vectorIndex2) throws Throwable {
            if (PlatoApplication.this.isUsingAssociationMatrix) {
                return this.assocMatrix.getElement(vectorIndex1, vectorIndex2);
            }
            float r = PlatoApplication.this.msPlato.linearCorrelationCoefficient(this.clusteredVectorArray[vectorIndex1].getComponents(), this.clusteredVectorArray[vectorIndex2].getComponents());
            float similarity = (float)(PlatoApplication.this.isUsingAbsR ? (double)Math.abs(r) : ((double)r + 1.0) / 2.0);
            return -((float)Math.sqrt(1.0 - Math.pow(similarity, PlatoApplication.this.alpha)));
        }

        float clusterNoncentrotype(int vectorIndex, int numClusters, int[] putativeCentrotypeIndices) throws Throwable {
            float maxAssoc = -2.0f;
            int bestCentrotypeIndex = -1;
            if (this.getIsCentrotype(vectorIndex, numClusters)) {
                throw new Exception("Vector of index " + vectorIndex + " is a centrotype.");
            }
            int k = 1;
            while (k <= numClusters) {
                int centrotypeIndex = putativeCentrotypeIndices[k - 1];
                float assoc = this.association(vectorIndex, centrotypeIndex);
                if (assoc > maxAssoc) {
                    maxAssoc = assoc;
                    bestCentrotypeIndex = centrotypeIndex;
                }
                ++k;
            }
            this.setClusterNumber(vectorIndex, numClusters, bestCentrotypeIndex);
            this.setCentrotypeAssociation(vectorIndex, numClusters, maxAssoc);
            return maxAssoc;
        }

        void clusterCentrotype(int centrotypeIndex, int numClusters) throws Throwable {
            if (!this.getIsCentrotype(centrotypeIndex, numClusters)) {
                throw new Exception("Vector of index " + centrotypeIndex + " is not a centrotype.");
            }
            this.setClusterNumber(centrotypeIndex, numClusters, centrotypeIndex);
            this.setCentrotypeAssociation(centrotypeIndex, numClusters, this.association(centrotypeIndex, centrotypeIndex));
        }

        float clusterAllVectors(int numClusters, int[] putativeCentrotypeIndices) throws Throwable {
            float totalAssoc = 0.0f;
            float numAssoc = 0.0f;
            if (numClusters != putativeCentrotypeIndices.length) {
                throw new Exception("numClusters==" + numClusters + "; putativeCentrotypeIndices.length==" + putativeCentrotypeIndices.length);
            }
            int i = 0;
            while (i < this.numClusteredVectors) {
                if (this.getIsCentrotype(i, numClusters)) {
                    this.clusterCentrotype(i, numClusters);
                } else {
                    totalAssoc += this.clusterNoncentrotype(i, numClusters, putativeCentrotypeIndices);
                    numAssoc += 1.0f;
                }
                ++i;
            }
            return totalAssoc / numAssoc;
        }

        void clusterAllVectors(int numClusters) throws Throwable {
            int i;
            int k = 0;
            int centrotypeIndex = -1;
            float meanAssoc = 0.0f;
            float maxMeanAssoc = -2.0f;
            int[] centrotypeIndices = new int[numClusters];
            if (numClusters > 1) {
                i = 0;
                while (i < this.numClusteredVectors) {
                    if (this.getIsCentrotype(i, numClusters - 1)) {
                        centrotypeIndices[k] = i;
                        ++k;
                        this.setIsCentrotype(i, numClusters, true);
                    }
                    ++i;
                }
            }
            if (k != numClusters - 1) {
                throw new Exception(String.valueOf(k) + "==k!=numClusters-1==" + (numClusters - 1));
            }
            centrotypeIndices[k] = -1;
            int relocationIteration = 0;
            while (relocationIteration <= PlatoApplication.this.maxNumRelocationIterations) {
                k = relocationIteration == 0 ? numClusters - 1 : 0;
                while (k < numClusters) {
                    int oldCentrotypeIndex = centrotypeIndices[k];
                    if (oldCentrotypeIndex != -1) {
                        if (!this.getIsCentrotype(oldCentrotypeIndex, numClusters)) {
                            throw new Exception("getIsCentrotype(centrotypeIndices[" + k + "]," + numClusters + ") should be true");
                        }
                        this.setIsCentrotype(oldCentrotypeIndex, numClusters, false);
                    }
                    centrotypeIndex = -1;
                    i = 0;
                    while (i < this.numClusteredVectors) {
                        if (!this.getIsCentrotype(i, numClusters)) {
                            centrotypeIndices[k] = i;
                            this.setIsCentrotype(i, numClusters, true);
                            meanAssoc = this.clusterAllVectors(numClusters, centrotypeIndices);
                            this.setIsCentrotype(i, numClusters, false);
                            if (meanAssoc >= maxMeanAssoc) {
                                maxMeanAssoc = meanAssoc;
                                centrotypeIndex = i;
                            }
                        }
                        ++i;
                    }
                    if (centrotypeIndex == -1) {
                        throw new Exception("centrotypeIndex==" + centrotypeIndex);
                    }
                    if (this.getIsCentrotype(centrotypeIndex, numClusters)) {
                        throw new Exception("getIsCentrotype(" + centrotypeIndex + "," + numClusters + ") should be false.");
                    }
                    this.setIsCentrotype(centrotypeIndex, numClusters, true);
                    centrotypeIndices[k] = centrotypeIndex;
                    this.meanCentrotypeAssociations[numClusters - 1] = this.clusterAllVectors(numClusters, centrotypeIndices);
                    if (this.getMeanCentrotypeAssociation(numClusters) != maxMeanAssoc) {
                        System.out.println();
                        System.out.println("WARNING:");
                        System.out.println("  getMeanCentrotypeAssociation(" + numClusters + ") is " + this.getMeanCentrotypeAssociation(numClusters) + ", but maxMeanAssoc is " + maxMeanAssoc + "; meanAssoc==" + meanAssoc + ".");
                        System.out.println();
                    }
                    ++k;
                }
                ++relocationIteration;
            }
        }

        void centrotypeClusterAnalysis(int numClusters) throws Throwable {
            System.out.println("Finding " + numClusters + " clusters.");
            this.clusterAllVectors(numClusters);
        }

        void centrotypeClusterAnalysis() throws Throwable {
            int k = 1;
            while (k <= PlatoApplication.this.maxNumClusters) {
                this.centrotypeClusterAnalysis(k);
                ++k;
            }
        }

        ClusteredVectors(Matrix listOfVectors) throws Throwable {
            this.numClusteredVectors = listOfVectors.getNumRows();
            this.meanCentrotypeAssociations = new float[PlatoApplication.this.maxNumClusters];
            this.clusteredVectorArray = new ClusteredVector[this.numClusteredVectors];
            int i = 0;
            while (i < this.numClusteredVectors) {
                PlatoApplication platoApplication = PlatoApplication.this;
                platoApplication.getClass();
                this.clusteredVectorArray[i] = platoApplication.new ClusteredVector(listOfVectors.getRow(i));
                ++i;
            }
            if (PlatoApplication.this.isUsingAssociationMatrix) {
                this.assocMatrix = new AssociationMatrix(listOfVectors);
                this.assocMatrix.printMatrix();
            }
            this.centrotypeClusterAnalysis();
        }
    }
}

