# General, Copyright (c) 2003-2004 by David R. Bickel.
# Last modified by David R. Bickel on 3/26/04.
# Created by David R. Bickel on 8/23/03.

print('loading MultCorr.r')
source("Estimation.r")
source("GraphVizSupp.r") # source("MultTests.r")

if(has.error(default.corromics.java.path)) default.corromics.java.path <- '.'#'Corromics super'

new.correlation.table.time.prefactor <- 1.4e-07 # the default prefactor is based on G3 iBook (640 MHz, 640 MB RAM), ppc-apple-macos, R 1.6.2, 11/28/03, nrow = 10000, ncol = 18

new.correlation.table.time <- function(nrow, ncol, prefactor = 
new.correlation.table.time.prefactor, units = c('minutes', 'seconds', 'hours'))
{
  units <- match.arg(units)
  sec <- prefactor * ncol * nrow^2
  if(units == 'seconds')
    sec
  else if(units == 'minutes')
    sec / 60
  else if(units == 'hours')
    sec / 3600
  else
    stop('units not recognized')
}

print.new.correlation.table.time <- function(nrow, ncol, prefactor = 
new.correlation.table.time.prefactor)
{
  sec <- new.correlation.table.time(nrow = nrow, ncol = ncol, prefactor = prefactor, units = 'seconds')
  min <- new.correlation.table.time(nrow = nrow, ncol = ncol, prefactor = prefactor, units = 'minutes')
  hou <- new.correlation.table.time(nrow = nrow, ncol = ncol, prefactor = prefactor, units = 'hours')
  tim <- if(min < 5)
    paste(sec, 'seconds')
  else if(hou < 2)
    paste(min, 'minutes')
  else
    paste(hou, 'hours')
  cool.cat('Estimated time to compute correlations: ', tim, ' from ', date())
}

permute.each.row <- function(vectorRows)
{
  rapply(vectorRows, sample)
}

matrix.after.resampling <- function(vectorRows, permute.columns, permute.row.wise)
{
  stopifnot(!permute.columns || !permute.row.wise)
  if(permute.columns) vectorRows <- resample.matrix(vectorRows)
  if(permute.row.wise) vectorRows <- permute.each.row(vectorRows)
  vectorRows
}

new.correlation.table <- function(vectorRows, permute.columns = FALSE, permute.row.wise = FALSE, transform.fun = rank, max.num.clusters = 0, cluster.alpha = 2, two.sided = TRUE, correlation.threshold = 0.9, corromics.java.path = default.corromics.java.path, file = 'correlation.table.xls', view.table = (!is.null(file) && file != ''), corromics.log.file = 'corromics.log.txt')
{
#  stop('Corromics.java needs to be corrected since rows 1 and 3 would not compared in vectorRows = mat.\nmat <- rbind(c(1,2,3,4,3.5), -c(1, 2, 3.1, 4, 3.4), c(1, 2, 1.5, 2, 1.5))') -- this works fine -- remember that correlations less than correlation.threshold will not appear in the table.
  stopifnot(is.matrix(vectorRows))
  vectorRows <- matrix.after.resampling(vectorRows, permute.columns = permute.columns, permute.row.wise = permute.row.wise)
  stopifnot(correlation.threshold >= -1 && correlation.threshold <= 1)
  if(!is.null(transform.fun)) vectorRows <- t(apply(vectorRows, 1, transform.fun))
#print(vectorRows)
  old.wd <- getwd()
  if(has.error(setwd(corromics.java.path))) stop(paste(corromics.java.path, 'is a bad corromics.java.path'))
  corr.table.file <- 'VectorRows-corr.txt'
  system(paste('rm', corr.table.file))
  save.spreadsheet(data.frame(matrix(c(max.num.clusters, cluster.alpha, if(two.sided) 1 else -1, correlation.threshold), ncol = 1)), file = 'Parameters.txt', row.names = FALSE, col.names = FALSE)
  save.spreadsheet(data.frame(vectorRows), file = 'VectorRows.txt', row.names = FALSE, col.names = FALSE)
  print.new.correlation.table.time(nrow = nrow(vectorRows), ncol = ncol(vectorRows))
  begin.date <- date()
#  cool.cat('Computing the correlation coefficients on ', begin.date, '...')
#  save.object(object = begin.date, 'begin.date')
  system(paste('java -jar Corromics.jar >', corromics.log.file))
  datf <- NULL
  while(is.null(datf) || nrow(datf) == 0) # This while loop is probably unneeded, but doesn not hurt.
    datf <- read.delim(file = corr.table.file, header = FALSE)
  end.date <- date()
#  save.object(object = end.date, 'end.date')
  cool.cat('  Start time: ', begin.date, '  End time: ', end.date)
  setwd(old.wd)
  # names(datf) <- c('Index1', 'Index2', 'R')
  # replace indices with names corresponding to vectorRows
  names(datf) <- c('x.name', 'y.name', 'correlation')
  names.from.indices <- function(field.name)
  {
    ind <- datf[, field.name]
    vectorNames <- rownames(vectorRows)
    if(is.null(vectorNames))
      ind
    else
      vectorNames[ind]
  }
  datf$x.name <- names.from.indices('x.name')
  datf$y.name <- names.from.indices('y.name')
  if(!is.null(file) && file != '')
  {
    save.spreadsheet(datf, file = file)
    if(view.table) open.unix(file)
  }
  datf
}

names.of.vectors <- function(vectorRows)
{
  if(is.null(rownames(vectorRows))) 1:nrow(vectorRows) else rownames(vectorRows)
}

correlation.table.names <- function(correlation.table, names0)
{
  stopifnot(is.vector(names0))
  stopifnot(is.data.frame(correlation.table))
  attach(correlation.table)
  stopifnot(!(is.null(x.name) || is.null(y.name)))
  corr.tab.names <- union(x.name, y.name)
  corr.tab.names.in.names0 <- intersect(corr.tab.names, names0)
  list(corr.tab.names = corr.tab.names, corr.tab.names.in.names0 = corr.tab.names.in.names0, corr.tab.names.not.in.names0 = setdiff(corr.tab.names, intersect(corr.tab.names, names0)))
}

is.correlation.table <- function(correlation.table)
{
  is.data.frame(correlation.table) && sum(names(correlation.table) == 'correlation') == 1 && sum(names(correlation.table) == 'x.name') == 1 && sum(names(correlation.table) == 'y.name') == 1 && !is.factor(correlation.table$x.name) && !is.factor(correlation.table$y.name)
}

is.correlation.shift.table <- function(correlation.shift.table)
{
  is.correlation.table(correlation.shift.table) && sum(names(correlation.shift.table) == 'y.lag') == 1
}

try.save.correlation.shift.table <- function(correlation.shift.table, file, view.table)
{
  if(!is.null(file) && file != '')
  {
    save.spreadsheet(correlation.shift.table, file = file)
    if(view.table) open.unix(file)
  }
  stopifnot(is.correlation.shift.table(correlation.shift.table))
}

read.correlation.table <- function(file)
{
  datf <- read.spreadsheet(file, as.is = TRUE)
  stopifnot(is.correlation.table(datf))
  datf
}

read.correlation.shift.table <- function(file) # changed on 12/22/03, but not tested
{
  datf <- read.correlation.table(file)
  stopifnot(is.correlation.shift.table(datf))
  datf
}

as.correlation.shift.table <- function(correlation.table, vectorRows, max.abs.lag = correlation.shift.max.abs.lag(ncol(vectorRows)), shifts = (-max.abs.lag):(max.abs.lag), file = 'correlation.shift.xls', concise = TRUE, view.table = (!is.null(file) && file != ''))
{
  if(is.character(correlation.table)) correlation.table <- read.correlation.table(correlation.table)
  stopifnot(!is.correlation.shift.table(correlation.table))
  stopifnot(is.correlation.table(correlation.table))
  stopifnot(is.matrix(vectorRows))
  vectorNames <- names.of.vectors(vectorRows)
  name.from.index <- function(index){correlation.name.from.index(index = index, nrows = nrow(vectorRows), vectorNames = vectorNames)} # changed on 12/22/03, but not tested
  shift.from.index <- function(index){correlation.shift.from.index(index = index, nrows = nrow(vectorRows), shifts = shifts)} # changed on 12/22/03, but not tested
  attach(correlation.table)
  x.shift <- I(sapply(x.name, shift.from.index))
  y.shift <- I(sapply(y.name, shift.from.index))
  datf <- data.frame(x.name = I(sapply(x.name, name.from.index)), y.name = I(sapply(y.name, name.from.index)), x.shift = x.shift, y.shift = y.shift, y.lag = x.shift - y.shift, correlation = correlation)
  try.save.correlation.shift.table(datf, file = file, view.table = view.table && !concise) # Function added 12/6/03, but not tested.
  if(concise)
    concise.correlation.shift.table(datf, file = file, view.table = view.table) # overwrites verbose file
  else
    datf
}

correlation.name.from.index <- function(index, nrows, vectorNames){stopifnot(is.numeric(index)); vectorNames[(index - 1) %% nrows + 1]}
correlation.shift.from.index <- function(index, nrows, shifts){stopifnot(is.numeric(index)); shifts[ceiling(index / nrows)]}

correlation.shift.max.abs.lag <- function(n.time.points, denominator = 8)
{default.max.abs.lag(n.time.points = n.time.points, denominator = denominator)}

new.correlation.shift.table <- function(vectorRows, permute.columns = FALSE, permute.row.wise = FALSE, max.abs.lag = correlation.shift.max.abs.lag(ncol(vectorRows)), shifts = (-max.abs.lag):(max.abs.lag), rank.shifted = FALSE, transform.fun = rank, max.num.clusters = 0, cluster.alpha = 2, two.sided = TRUE, correlation.threshold = 0.9, corromics.java.path = default.corromics.java.path, file = 'correlation.shift.xls', correlation.table.file = '', concise = TRUE, view.table = (!is.null(file) && file != ''), corromics.log.file = 'corromics.log.txt')
{
  vectorRows <- matrix.after.resampling(vectorRows, permute.columns = permute.columns, permute.row.wise = permute.row.wise)
  shift.matrix <- function(shift){rapply(vectorRows, function(vectorRow){shift(vectorRow, shift = shift, rank.shifted = rank.shifted)})}
  cool.cat(date(), ': shifting data to prepare for computations of correlation coefficients.')
  mat.with.shifts <- do.call('rbind', lapply(shifts, function(shift){shift.matrix(shift)}))
  rownames(mat.with.shifts) <- NULL
  vectorNames <- names.of.vectors(vectorRows) # Function added 12/6/03 without testing.
  if(any(vectorNames == ''))
  {
    warning(paste(sum(vectorNames == ''), 'vectorNames were left blank and are treated as if the same name'))
    vectorNames <- 	ifelse(vectorNames == '', 'Untitled', vectorNames)
  }
  name.from.index <- function(index){correlation.name.from.index(index = index, nrows = nrow(vectorRows), vectorNames = vectorNames)} # changed on 12/22/03, but not tested
  shift.from.index <- function(index){correlation.shift.from.index(index = index, nrows = nrow(vectorRows), shifts = shifts)} # changed on 12/22/03, but not tested
  
  stopifnot(nrow(mat.with.shifts) == nrow(vectorRows) * length(shifts))
  if(has.error(corromics.java.path) || is.null(corromics.java.path)) {print('bad corromics.java.path'); browser()} 
  ct <- new.correlation.table(vectorRows = mat.with.shifts, permute.columns = FALSE, permute.row.wise = FALSE, transform.fun = transform.fun, max.num.clusters = max.num.clusters, cluster.alpha = cluster.alpha, two.sided = two.sided, correlation.threshold = correlation.threshold, corromics.java.path = corromics.java.path, file = correlation.table.file, view.table = FALSE, corromics.log.file = corromics.log.file)
  if(has.error(cst <- as.correlation.shift.table(ct, vectorRows = vectorRows, max.abs.lag = max.abs.lag, shifts = shifts, file = file, concise = concise, view.table = view.table))) {print('error in cst'); browser()}
  cst
}
#as.correlation.shift.table <- function(correlation.table, vectorRows, max.abs.lag = correlation.shift.max.abs.lag(ncol(vectorRows)), shifts = (-max.abs.lag):(max.abs.lag), file = 'correlation.shift.xls', concise = TRUE, view.table = (!is.null(file) && file != ''))

concise.correlation.shift.table <- function(correlation.shift.table, file = 'cor.shift.xls', view.table = (!is.null(file) && file != ''))
{
  if(is.character(correlation.shift.table)) correlation.shift.table <- read.correlation.table(correlation.shift.table)
  stopifnot(is.correlation.shift.table(correlation.shift.table))
#  if(nrow(correlation.shift.table) == 0) return(correlation.shift.table)
  attach(correlation.shift.table)
  correlation.shift.table <- correlation.shift.table[!((x.name == y.name & y.lag == 0) | (x.shift * y.shift > 0)), ]
  attach(correlation.shift.table)
  reverse.names.boo <- y.lag < 0
  correlation.shift.table <- data.frame(x.name = I(ifelse(reverse.names.boo, y.name, x.name)), y.name = I(ifelse(reverse.names.boo, x.name, y.name)), x.shift = ifelse(reverse.names.boo, y.shift, x.shift), y.shift = ifelse(reverse.names.boo, x.shift, y.shift), y.lag = ifelse(reverse.names.boo, -y.lag, y.lag), correlation = correlation)
  stopifnot(is.correlation.shift.table(correlation.shift.table))
  names.cst <- c('x.name', 'y.name', 'y.lag', 'correlation')
  if(nrow(correlation.shift.table) == 0) return(correlation.shift.table[, names.cst])
  attach(correlation.shift.table)
  arr <- tapply(X = correlation, INDEX = list(as.factor(x.name), as.factor(y.name), as.factor(y.lag)), FUN = extreme.cor)
  add.to.datf <- function(datf, x.name, y.name, y.lag, correlation){data.frame(x.name = I(c(datf$x.name, x.name)), y.name = I(c(datf$y.name, y.name)), y.lag = c(datf$y.lag, y.lag), correlation = c(datf$correlation, correlation))}
  new.datf <- function(){data.frame(x.name = I(character(0)), y.name = I(character(0)), y.lag = numeric(0), correlation = numeric(0))}
  datf <- new.datf()
  for(i in dimnames(arr)[[1]])
    for(j in dimnames(arr)[[2]])
    {
      sub.datf <- new.datf()
      for(k in dimnames(arr)[[3]])
      {
        r <- arr[i, j, k]
        if(!is.na(r))
        {
           sub.datf <- add.to.datf(datf = sub.datf, x.name = i, y.name = j, y.lag = as.numeric(k), correlation = as.numeric(r)) # rbind(datf, c(i, j, k, r))
        }
      }
      if(nrow(sub.datf) > 0)
      {
        cors <- sub.datf$correlation
        stopifnot(length(cors) > 0)
        max.cor.boo <- sapply(1:length(cors), function(k){length(cors) == 1 || (k == 1 && cors[1] >= cors[2]) || (k == length(cors) && cors[length(cors)] >= cors[length(cors) - 1]) || (k > 1 && k < length(cors) && cors[k] >= cors[k - 1] && cors[k] >= cors[k + 1])}) # error corrected 12/20/03 7:14 pm
        stopifnot(sum(max.cor.boo) > 0 && sum(max.cor.boo) <= nrow(sub.datf))
        if(sum(max.cor.boo) > 1) warning(paste('There are', sum(max.cor.boo), 'repeated vector pairs for i==', i, 'j==', j))
        datf <- rbind(datf, sub.datf[max.cor.boo, ])
#cool.cat(i, j, sep = ', ')
#print(sub.datf)
#print(datf)
      }
    }
  if(has.error(row.names(datf) <- 1:nrow(datf)))
  {
    print('error in row.names(datf) <- 1:nrow(datf)')
    browser()
  }
  try.save.correlation.shift.table(datf, file = file, view.table = view.table) # Function added 12/6/03, but not tested.
  datf
}

nonzero.y.lag.correlation.shift.table <- function(correlation.shift.table)
{
  stopifnot(is.correlation.shift.table(correlation.shift.table))
  stopifnot(all(correlation.shift.table$y.lag >= 0))
  datf <- correlation.shift.table[correlation.shift.table$y.lag > 0, ]
  stopifnot(is.correlation.shift.table(datf))
  datf
}

p.value.correlation.shift.table <- function(vectorRows, correlation.shift.table, nresample, correlation.threshold = 0.9, y.lag.threshold = 1, alternative = c("two.sided", "less", "greater"), file = 'cor.shift.xls', view.table = (!is.null(file) && file != ''), ...)
{
  stopifnot(is.correlation.shift.table(correlation.shift.table))
  stopifnot(is.matrix(vectorRows))
  stopifnot(!is.null(nresample) && nresample > 0)
  rownames(vectorRows) <- names.of.vectors(vectorRows) # added 3/26/04
  cat('There were', nrow(correlation.shift.table),'correlations before applying the thresholds, and ')
  correlation.shift.table <- correlation.shift.table[abs(correlation.shift.table$correlation) >= correlation.threshold & correlation.shift.table$y.lag >= y.lag.threshold, ] # added 12/24/03; tested on 12/26/03 on Cuatro (G4)
  stopifnot(nrow(correlation.shift.table) >= 1)
  cat(nrow(correlation.shift.table), 'correlations after.\n')
  vectorNames <- names.of.vectors(vectorRows) # Function added 12/6/03 without testing.
  is.vectorName <- function(name.in.cst)
  { name.count <- sum(name.in.cst == vectorNames); stopifnot(name.count <= 1); name.count >= 1}
  check.name.field <- function(name.field.name)
  { 
    names <- correlation.shift.table[, name.field.name]
    stopifnot(is.character(names))
    sapply(names, 
      function(a.name){if(!is.vectorName(a.name)) {cool.cat(a.name, ' of ', name.field.name, ' is not a name of a vector in vectorRows.'); browser()}}
    )
  }
  check.name.field('x.name')
  check.name.field('y.name')
  datf <- nonzero.y.lag.correlation.shift.table(correlation.shift.table)
  get.vectorRow <- function(datf.row.index, datf.col.index) 
  {
    vr <- vectorRows[datf[datf.row.index, datf.col.index], ]
    if(has.error(vr) || !is.vector(vr) || length(vr) != ncol(vectorRows)) {print('vectorRow error'); browser()}
    vr
  }
  datf$p.value <- sapply(1:nrow(datf), function(k){y.lag <- datf[k, 'y.lag']; stopifnot(y.lag >= 1); if(has.error(x <- get.vectorRow(k, 'x.name'))) {print('x error'); browser()}; if(has.error(y <- get.vectorRow(k, 'y.name'))) {print('y error'); browser()}; if(length(x) != length(y)) {print('p.value.correlation.shift.table error: length(x) != length(y)'); browser()}; y.lag.p.value(x = x, y = y, x.is.reference = FALSE, y.lag = y.lag, y.lags = c(0, y.lag), nresample = nresample, alternative = alternative, ...)})
  try.save.correlation.shift.table(datf, file = file, view.table = view.table)
  datf
}

plot.correlation.shift.table <- function(correlation.shift.table, graph.name = 'corr.shift.graph', table.file = paste(graph.name, 'txt', sep = '.'), graphics.file = paste(graph.name, 'ps', sep = '.'))
{
  stopifnot(is.correlation.shift.table(correlation.shift.table))
  correlation.shift.table <- nonzero.y.lag.correlation.shift.table(correlation.shift.table) # Function added 12/3/03, but not tested.
  lag.char <- as.character(correlation.shift.table$y.lag)
  lag.char.plus <- sapply(lag.char, function(lc){paste(lc, '+', sep = '')})
  lag.char.minus <- sapply(lag.char, function(lc){paste(lc, '-', sep = '')})
  correlation.shift.table$label <- ifelse(correlation.shift.table$correlation >=0, lag.char.plus, lag.char.minus)
  plot.graph.table(x = correlation.shift.table, node1.name = 'x.name', node2.name = 'y.name', label.name = 'label', graph.name = graph.name, table.file = table.file, graphics.file = graphics.file)
}

correlation.threshold.dFDR <- function(correlation.table, random.correlation.table, correlation.threshold = c(.9, .95), y.lag.threshold = rep(1, length(correlation.threshold)))
{
  if(!is.data.frame(random.correlation.table))
  {
    stopifnot(is.list(random.correlation.table))
    nrealizations <- length(random.correlation.table)
    random.correlation.table <- do.call('rbind', random.correlation.table)
  }
  else
    nrealizations <- 1
  stopifnot(is.correlation.table(correlation.table) && is.correlation.table(random.correlation.table))
  stopifnot(ncol(correlation.table) == ncol(random.correlation.table))
  stopifnot(length(correlation.threshold) == length(y.lag.threshold))
  nreject <- function(cor.table){sapply(1:length(correlation.threshold), function(i){if(nrow(cor.table) == 0) 0 else sum(abs(cor.table$correlation) >= correlation.threshold[i] & cor.table$y.lag >= y.lag.threshold[i])})}
  nreject.data <- nreject(correlation.table)
  nreject.random <- nreject(random.correlation.table) / nrealizations
  dFDR <- ifelse(nreject.data == 0, 0, pmin(1, nreject.random / nreject.data))
  data.frame(correlation.threshold = correlation.threshold, y.lag.threshold = y.lag.threshold, nreject.data = nreject.data, nreject.random = nreject.random, dFDR = dFDR)
}

connectivity <- function(correlation.table, use.browser = FALSE)
{
  stopifnot(is.correlation.table(correlation.table))
  if(!is.correlation.shift.table(correlation.table)) {print('connectivity() is not yet implemented for general correlation.tables; apply correlation.shift.table().'); stop('Continuing could produce misleading connectivities since the same gene pairs of different matrix shifts would be treated as unique edges.')}
  attach(correlation.table)
  switch.boo <- x.name > y.name
  sorted.table <- data.frame(x.name = I(as.character(ifelse(switch.boo, y.name, x.name))), y.name = I(as.character(ifelse(switch.boo, x.name, y.name))))
  original.names <- make.names(sapply(1:nrow(sorted.table), function(i){paste(sorted.table[i, 'x.name'], sorted.table[i, 'y.name'], sep = '.')}))
  cool.cat('Determining uniqueness of vector pairs on ', date())
  rownames(sorted.table) <- make.names(original.names, unique = TRUE) # perhaps more computationally intense than O(n)
  if(use.browser) browser()
  sorted.table <- sorted.table[rownames(sorted.table) == original.names, ]
  cool.cat(nrow(correlation.table) - nrow(sorted.table), ' of ', nrow(correlation.table), ' rows of correlation.table were not needed since they repeat pairs of vectors')
  vectorNames <- union(sorted.table$x.name, sorted.table$y.name)
  stopifnot(length(vectorNames) == length(unique(vectorNames)))
  connectivities <- sapply(vectorNames, function(vecName){sum(xor(vecName == sorted.table$x.name, vecName == sorted.table$y.name))})
  if(!all(connectivities >= 0)) {print('bad connectivities'); browser()}
  connectivities
}

nconnections <- function(connectivities) {stopifnot(is.vector(connectivities)); stopifnot(sum(connectivities) %% 2 == 0); sum(connectivities) / 2}

model.connectivity.nls.pred <- function(arglog, a, b, beta) {a - (b/(beta+1)) * (arglog^(beta+1) - 1)}
model.connectivity.nls.fun <- function(arglog, p, a, b, beta) {pred <- model.connectivity.nls.pred(arglog, a, b, beta); pred - p}

model.connectivity.by.correlation.threshold <- function(correlation.table, correlation.threshold = 0.9, ...)
{
  stopifnot(is.correlation.table(correlation.table))
  stopifnot(is.vector(all(correlation.threshold >= 0)) && all(correlation.threshold >= 0) && all(correlation.threshold <= 1))
  attach(correlation.table)
  stopifnot(max(correlation.threshold) <= max(abs(correlation)))
  model.connectivity.list <- lapply(correlation.threshold,
    function(r0)
    {
      datf <- correlation.table[abs(correlation) >= r0, ]
      stopifnot(nrow(datf) >= 1)
      stopifnot(is.correlation.table(datf))
      if(has.error(quartz())) warning('Some plots suppressed on non-Aqua (Mac OS X) system.')
      model.connectivity(connectivities.or.correlation.table = datf, main.title = paste('r0 ==', r0, ',', date()), ...)
    }
  )
  extract.nls.estimates <- function(estimate.name){sapply(model.connectivity.list, function(mc){mc$nls.estimates[estimate.name]})}
  extract.n.connections <- function(){sapply(model.connectivity.list, function(mc){mc$n.connections})}
  beta <- extract.nls.estimates('beta')
  a <- extract.nls.estimates('a')
  b <- extract.nls.estimates('b')
  n.connections <- extract.n.connections()
  ncor <- nrow(correlation.table)
  if(is.null(beta[[1]]) || any(length(correlation.threshold) != c(length(beta), length(a), length(b)))) {print('length error'); browser()}
  nls.estimates.table <- data.frame(correlation.threshold = correlation.threshold, beta = beta, a = a, b = b, n.connections = n.connections)
  if(is.null(nls.estimates.table$correlation.threshold) || is.null(nls.estimates.table$beta))
  { print('nls.estimates.table problem'); print(nls.estimates.table); browser()}
  if(has.error(quartz())) warning('Some plots suppressed on non-Aqua (Mac OS X) system.')
  plot(nls.estimates.table$correlation.threshold, nls.estimates.table$beta, xlab = 'r0', ylab = 'beta', main = paste('mcbct', date()), sub = paste(ncor, 'correlations'))
  if(has.error(quartz())) warning('Some plots suppressed on non-Aqua (Mac OS X) system.')
  plot(nls.estimates.table$correlation.threshold, n.connections, xlab = 'r0', ylab = '# connections', main = paste('mcbct', date()), sub = paste('(out of', ncor, 'correlations)'))
  list(model.connectivity.list = model.connectivity.list, nls.estimates.table = nls.estimates.table)
}

model.connectivity <- function(connectivities.or.correlation.table, control = nls.control(maxiter = 500), main.title = paste('model.connectivity', date()), min.arglog = .3, prediction.col = 'black', power.law.prediction.col = 'red', nls.prediction.col = 'blue', xlab = c('connectivity', 'arglog'), x.axis.plot = c('linear', 'both', 'log', 'no.plot'), tail.plot = TRUE, continuity.correct = TRUE, a = NULL, ...)
# Based on H. Agrawal, PRL 89, 268702 (2002)
{
  connectivities <- if(is.correlation.table(connectivities.or.correlation.table))
    connectivity(connectivities.or.correlation.table)
  else
    connectivities.or.correlation.table
  stopifnot(is.vector(connectivities))
  xlab <- match.arg(xlab)
  x.axis.plot <- match.arg(x.axis.plot)
  conn <- sort(unique(connectivities))
  arglog <- (conn + 1)/(max(conn) + 1)
  neg.log.arglog <- -log(arglog)
  p <- sapply(conn, function(q) {pdata(data.vec = connectivities, q = q, continuity.correct = continuity.correct, a = a, lower.tail = FALSE, ...)})
  log.p <- log(p)
  data0 <- data.frame(connectivity = conn, p = p, arglog = arglog, neg.log.arglog = neg.log.arglog, log.p = log.p)
  data <- data0[data0$arglog >= min.arglog, ]
  model = lm(p ~ neg.log.arglog, data = data)
  data0$prediction = lm.predictions(x.vec = data0$neg.log.arglog, lm.output = model)
  power.law.model <- power.law.lm(x = data$arglog, y = data$p) # lm(log.p ~ neg.log.arglog, data = data)
  data0$power.law.prediction = exp(lm.predictions(x.vec = log(data0$arglog), lm.output = power.law.model))
  blank.nls.estimates <- function()
  {
    warning(paste('nls.estimates set to NA for', length(connectivities), 'connectivities.'))
    c(a = NA, b = NA, beta = NA)
  }
  if(has.error( nls.model <- nls( ~ model.connectivity.nls.fun(arglog, p, a, b, beta), data = data, start = list(a = 0.055, b = 0.6, beta = -1.5), control = control) ))
  { warning('nls.model error'); nls.model <- NULL; nls.estimates <- blank.nls.estimates()}
  if(has.error(nls.estimates <- summary(nls.model)$parameters[, 'Estimate']) || is.null(nls.estimates))
  { nls.estimates <- blank.nls.estimates()}
  if(has.error(nls.estimates) || is.null(nls.estimates) || !is.vector(nls.estimates) || length(nls.estimates) != 3)
  { print('bad nls.estimates:'); print(nls.estimates); browser()}
  data0$nls.prediction <- sapply(data0$arglog, function(arglog){if(any(is.na(nls.estimates))) NA else model.connectivity.nls.pred(arglog, a = nls.estimates['a'], b = nls.estimates['b'], beta = nls.estimates['beta'])})
  attach(data0)
  x <- if(xlab == 'connectivity')
    conn
  else if(xlab == 'arglog')
    arglog
  else stop('xlab error')
  if(has.error(sub.title <- paste('beta ==', if(is.na(nls.estimates['beta'])) 'NA' else round(nls.estimates['beta'], digits = 2))))
  { sub.title <- 'error in beta estimate'}
  plotted.p.vs.arglog <- FALSE
  plot.p.vs.arglog <- function()
  {
    if(!plotted.p.vs.arglog)
    {
      if(x.axis.plot == 'both')
        if(has.error(quartz())) {warning('Both plots can only be plotted simultaneously with an Aqua (Mac OS X) version of R.')}
      plot(x, p, xlab = xlab, main = main.title, sub = sub.title)
    }
    TRUE
  }
  linear.plot <- function(y, col){lines(x, y, col = col)}
  lines.prediction <- function(){linear.plot(y = prediction, col = prediction.col)}
  lines.power.law.prediction <- function(){linear.plot(y = power.law.prediction, col = power.law.prediction.col)}
  lines.nls.prediction <- function(){if(any(is.na(nls.prediction))) warning(paste('no plot of nls.prediction for', length(connectivities), 'connectivities on', date())) else linear.plot(y = nls.prediction, col = nls.prediction.col)}
  if(x.axis.plot == 'log' || x.axis.plot == 'both')
  {
    plot(neg.log.arglog, p)
    lines(neg.log.arglog, prediction)
  }
  if(x.axis.plot == 'linear' || x.axis.plot == 'both')
  {
    plotted.p.vs.arglog <- plot.p.vs.arglog()
    lines.prediction()
  }
  if(x.axis.plot == 'linear' || x.axis.plot == 'both')
  {
    plotted.p.vs.arglog <- plot.p.vs.arglog()
    lines.power.law.prediction()
  }
  if(x.axis.plot == 'linear' || x.axis.plot == 'both')
  {
    plotted.p.vs.arglog <- plot.p.vs.arglog()
    lines.nls.prediction()
  }
  if(tail.plot)
  {
    if(has.error(quartz())) {warning('Multiple plots can only be plotted simultaneously with an Aqua (Mac OS X) version of R.')}
    plot(x[arglog >= min.arglog], p[arglog >= min.arglog], xlab = xlab, ylab = 'p', main = main.title, sub = sub.title)
    lines.prediction()
    lines.power.law.prediction()
    lines.nls.prediction()
  }
  list(model = model, nls.model = nls.model, power.law.model = power.law.model, data0 = data0, r.squared = summary(model)$r.squared, nls.estimates = nls.estimates, n.connections = nconnections(connectivities))
}
