# GraphVizSupp, Copyright (c) 2003-2004 by David R. Bickel.
# Called DarwinGraphViz before 3/25/04.
# Last modified by David R. Bickel on 3/25/04.
# Created by David R. Bickel on 12/1/03.

source("General.r")

is.graph.table <- function(x)
{
#  stopifnot(is.data.frame(x))
#  stopifnot(is.character(x$node1))
#  stopifnot(is.character(x$node2))
#  stopifnot(is.character(x$label))
  is.x.name <- function(test.name){sum(test.name == names(x)) >= 1}
  is.data.frame(x) && is.x.name('node1') && is.x.name('node2') && is.x.name('label') && is.character(x[, 'node1']) && is.character(x[, 'node2']) && is.character(x[, 'label'])
}

as.graph.table <- function(x, node1.name = stop('Argument missing in as.graph.table'), node2.name = stop('Argument missing in as.graph.table'), label.name = stop('Argument missing in as.graph.table'))
{
  stopifnot(is.data.frame(x))
  coerce.column <- function(column.name){column <- x[, column.name]; stopifnot(!is.factor(column)); as.character(column)}
  x <- data.frame(node1 = I(coerce.column(node1.name)), node2 = I(coerce.column(node2.name)), label = I(coerce.column(label.name))) 
  stopifnot(is.graph.table(x))
  x
}

save.graph.table <- function(x, file = 'graph.txt', language = c('DOT', 'R'), size.inches = c(8, 8))
{
  stopifnot(is.graph.table(x))
  language = match.arg(language)
  if(language == 'R')
    save.spreadsheet(x, file = file)
  else if(language == 'DOT')
  {
    string.to.save <- paste('digraph G {size = "', as.character(size.inches[1]), ', ', as.character(size.inches[2]), '"; ', sep = '')
    for(i in 1:nrow(x))
    {
      lab <- x[i, 'label']
      string.to.save <- paste(string.to.save, x[i, 'node1'], '->', x[i, 'node2'], if(is.na(lab)) '' else paste('[label="', lab, '"]', sep = ''), ';')
    }
    string.to.save <- paste(string.to.save, '} /*This file was created on', date(), ' for the DOT program of GraphViz (AT&T) by the R program GraphVizSupp (Copyright (c) 2003-2004 by David R. Bickel; part of the Statomics software available from www.davidbickel.com).*/')
    write(x = string.to.save, file = file)
  }
  else
    stop('Unsupported language.')
}

plot.graph.table <- function(x = NULL, node1.name = NULL, node2.name = NULL, label.name = NULL, graph.name = 'graph', table.file = paste(graph.name, 'txt', sep = '.'), graphics.file = paste(graph.name, 'ps', sep = '.'), size.inches = c(8, 8))
{
  if(is.null(x))
    print('x not specified, so a saved graph table will be plotted')
  else
  {
    if(!is.graph.table(x))
    {
      stopifnot(!any(sapply(list(node1.name, node2.name, label.name), is.null)))
      x <- as.graph.table(x = x, node1.name = node1.name, node2.name = node2.name, label.name = label.name)
    }
    stopifnot(is.graph.table(x))
    save.graph.table(x = x, file = table.file, language = 'DOT', size.inches = size.inches)    
  }
  system(paste('dot -Tps', table.file, '-o', graphics.file))
    # system(paste('dot -Tps', add.quotes(table.file), '-o', add.quotes(graphics.file)))
  open.unix(graphics.file)
}

