/*
 * Decompiled with CFR 0.152.
 */
package Corromics;

public class MomentStats {
    public float mean(float[] sample) {
        int sampleSize = sample.length;
        float sum = 0.0f;
        int i = 0;
        while (i < sampleSize) {
            sum += sample[i];
            ++i;
        }
        return sum / (float)sampleSize;
    }

    public float variance(float[] sample) {
        float meanValue = this.mean(sample);
        int sampleSize = sample.length;
        float sum = 0.0f;
        int i = 0;
        while (i < sampleSize) {
            sum += (sample[i] - meanValue) * (sample[i] - meanValue);
            ++i;
        }
        return sum / (float)(sampleSize - 1);
    }

    public float standardDeviation(float[] sample) {
        return (float)Math.sqrt(this.variance(sample));
    }

    public float standardErrorOfSampleMean(float[] sample) {
        int sampleSize = sample.length;
        return this.standardDeviation(sample) / (float)Math.sqrt(sampleSize);
    }

    public float linearCorrelationCoefficient(float[] sample1, float[] sample2) throws Throwable {
        float mean1 = this.mean(sample1);
        float mean2 = this.mean(sample2);
        float sumOfSquares1 = 0.0f;
        float sumOfSquares2 = 0.0f;
        float sumOfProducts = 0.0f;
        int sampleSize = sample1.length;
        if (sample1.length != sample2.length) {
            throw new Exception("sample1 has " + sample1.length + ", but sample2 has " + sample2.length + " values.");
        }
        int i = 0;
        while (i < sampleSize) {
            float value1 = sample1[i] - mean1;
            float value2 = sample2[i] - mean2;
            sumOfSquares1 += value1 * value1;
            sumOfSquares2 += value2 * value2;
            sumOfProducts += value1 * value2;
            ++i;
        }
        return sumOfProducts / (float)Math.sqrt(sumOfSquares1 * sumOfSquares2);
    }
}

